<?php
/**
 * Plugin Name:     Zapomatic - The Ultimate Zap Tool For WooCommerce
 * Description:     Mirror site generator and prices updater for Zap - NEVER STAY BEHIND!
 * Version:         4.0.0
 * Author:          Tovel Web Solutions
 * Author URI:      https://tovel.co.il/
 * Text Domain:     zapomatic
 * Domain Path:     /languages
 */
 if ( ! defined( 'ABSPATH' ) ) die;

 define( 'ZAPOMATIC_DIR', plugin_dir_path( __FILE__ ) );
 define( 'ZAPOMATIC_URL',  plugin_dir_url( __FILE__ ) );

 final class Zapomatic_Plugin {

    private static $instance;
    protected $error;
    protected $overview;
    protected $tools;
    protected $db;
    protected $spy;

    public static function getInstance() {

        if ( ! isset( self::$instance ) ) {
            self::$instance = new self;
        }
        return self::$instance;

    }

    public static function plugin_info( $data = null ) {

        if ( ! function_exists( 'get_plugins' ) ) require_once ABSPATH . 'wp-admin/includes/plugin.php';
        $plugin_data = get_plugin_data( __FILE__ );
        if ( $data === null ) return plugin_basename( __FILE__ );
        return $plugin_data[ $data ];

    }

    public function __construct() {

        require_once('includes/class-engine.php');
        require_once('includes/class-updater.php');
        if ( class_exists( 'Zapomatic_Spy' ) ) {
            $this->spy = true;
            Zapomatic_Spy::register_hooks();
        }
        $this->error = get_option( 'zapbott_error' );
        $this->init_tools();
        $this->register_hooks();

    }

    private function register_hooks() {

        add_filter( 'plugin_action_links_zapomatic/zapomatic.php', array( $this, 'plugins_settings_link' ) );
        add_action( 'admin_init', array( $this, 'admin_init' ) );
        add_action( 'admin_menu', array( $this, 'create_admin_menu' ) );
        add_action( 'admin_enqueue_scripts', array($this, 'admin_enqueue_scripts' ) );
        add_action( 'admin_head', array( $this, 'admin_head' ) );
        add_action( 'admin_footer', array($this, 'admin_footer' ) );
        add_action( 'update_option_zapbott_option_scrap_freq', array( $this, 'update_scrap_freq_option' ) );
        add_action( 'update_option_zapbott_full_exec_heartbeat', function () {
            wp_cache_delete( 'zapbott_full_exec_heartbeat', 'options' );
        });
        add_action( 'wp_dashboard_setup', array( $this, 'add_dashboard_widgets' ) );
        add_action( 'wp_ajax_zapomatic_dashboard_refresh', array( $this, 'dashboard_refresh' ) );
        add_action( 'woocommerce_product_bulk_edit_end', array( $this, 'add_bulk_edit_fields' ) );
        add_action( 'woocommerce_product_bulk_edit_save', array( $this, 'update_bulk_edit_fields' ), 10 );
        add_action( 'wp_ajax_zapbott_test_connection', array( $this, 'test_connection' ) );
        register_activation_hook( __FILE__, array( $this, 'plugin_activation' ) );
        register_deactivation_hook( __FILE__, array( $this, 'plugin_deactivation' ) );
        add_filter( 'woocommerce_product_data_tabs', array( $this,'edit_product_data_tab' ) , 98 , 1 );
        add_action( 'woocommerce_product_data_panels', array( $this, 'edit_product_data_fields' ) );
        add_action( 'woocommerce_process_product_meta', array($this, 'edit_product_data_fields_update' ), 98 );
        add_filter( 'manage_product_posts_columns', array( $this, 'admin_columns' ) );
        add_action( 'manage_product_posts_custom_column' , array( $this, 'admin_columns_data' ), 10, 2 );
        add_action( 'restrict_manage_posts', array( $this, 'admin_filter' ), 100 );
        add_action( 'pre_get_posts', array( $this, 'admin_filter_results' ) );
        add_filter( 'bulk_actions-edit-product', array( $this, 'edit_products_bulk_actions' ) );
        add_action( 'handle_bulk_actions-edit-product', array( $this, 'edit_products_bulk_actions_handle' ), 20, 3 );
        add_action( 'admin_notices', array( $this, 'edit_products_bulk_actions_notices' ) );
        add_action( 'product_cat_add_form_fields', array( $this, 'add_category_shipment_cost' ), 10, 2 );
        add_action( 'product_cat_edit_form_fields', array( $this, 'edit_category_shipment_cost' ), 10, 2 );
        add_action( 'created_product_cat', array( $this, 'save_category_shipment_cost' ), 10, 2 );
        add_action( 'edited_product_cat', array( $this, 'save_category_shipment_cost' ), 10, 2 );
        Zapomatic_Updater::register_hooks();
        $this->tools->register_hooks();

    }


    public function plugins_settings_link( $links ) {

        $url = esc_url( add_query_arg(
            'page',
            'zapomatic_settings',
            get_admin_url() . 'admin.php'
        ) );
        $settings_link = "<a href='$url'>" . __( 'הגדרות', 'zapomatic' ) . '</a>';
        array_push(
            $links,
            $settings_link
        );
        return $links;

    }

    protected function init_db() {

        if ( $this->db ) return;
        require_once('includes/class-database.php');
        $this->db = new Zapomatic_Database;
        return;

    }

    public function admin_init() {

        $this->register_setting_group();

    }

    public function create_admin_menu() {

        add_menu_page(
            __( 'זאפומטיק', 'zapomatic' ),
            __( 'Zapomatic', 'zapomatic' ),
            'manage_woocommerce',
            'zapomatic',
            array( $this, 'menu_overview_callback' ),
            plugin_dir_url( __FILE__ ) . 'images/menu.svg',
            56
        );
        add_submenu_page(
            'zapomatic',
            __( 'סקירה - זאפומטיק', 'zapomatic' ),
            __( 'סקירה', 'zapomatic' ),
            'manage_woocommerce',
            'zapomatic',
            array( $this, 'menu_overview_callback' ),
        );
        add_submenu_page(
            'zapomatic',
            __( 'כלים - זאפומטיק', 'zapomatic' ),
            __( 'כלים', 'zapomatic' ),
            'manage_woocommerce',
            'zapomatic_tools',
            array( $this, 'menu_tools_callback' ),
        );
        add_submenu_page(
            'zapomatic',
            __( 'הגדרות - זאפומטיק', 'zapomatic' ),
            __( 'הגדרות', 'zapomatic' ),
            'manage_woocommerce',
            'zapomatic_settings',
            array( $this, 'menu_settings_callback' )
        );

    }

    public function admin_enqueue_scripts() {

        wp_register_style( 'zapomatic_edit_products_css', plugin_dir_url( __FILE__ ) . 'admin/css/edit-products.css', array(), date("ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/css/edit-products.css')) );
        wp_register_style( 'zapomatic_overview_css', plugin_dir_url( __FILE__ ) . 'admin/css/overview.css', array(), date("ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/css/overview.css')) );
        wp_register_style( 'zapomatic_tools_css', plugin_dir_url( __FILE__ ) . 'admin/css/tools.css', array(), date("ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/css/tools.css')) );
        wp_register_style( 'zapomatic_dashboard_css', plugin_dir_url( __FILE__ ) . 'admin/css/dashboard.css', array(), date("ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/css/dashboard.css')) );
        wp_register_script(
            'zapomatic_options_js',
            plugin_dir_url( __FILE__ ) . 'admin/js/options.js',
            array(),
            date( "ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/js/options.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_dashboard_js',
            plugin_dir_url( __FILE__ ) . 'admin/js/dashboard.js',
            array(),
            date( "ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/js/dashboard.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_import_models',
            plugin_dir_url( __FILE__ ) . 'admin/js/import-models.js',
            array(),
            date( "ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/js/import-models.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_import_data',
            plugin_dir_url( __FILE__ ) . 'admin/js/import-data.js',
            array(),
            date( "ymd-Gis", filemtime( plugin_dir_path( __FILE__ ) . 'admin/js/import-data.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_chartjs',
            'https://cdn.jsdelivr.net/npm/chart.js',
            array(),
            null,
            true
        );
        wp_register_script(
            'zapomatic_overview',
            ZAPOMATIC_URL . 'admin/js/overview.js',
            array(),
            date( "ymd-Gis", filemtime( ZAPOMATIC_DIR . 'admin/js/overview.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_overview_pc',
            ZAPOMATIC_URL . 'admin/js/overview-positions-competitors.js',
            array(),
            date( "ymd-Gis", filemtime( ZAPOMATIC_DIR . 'admin/js/overview-positions-competitors.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_overview_runtime',
            ZAPOMATIC_URL . 'admin/js/overview-runtime.js',
            array(),
            date( "ymd-Gis", filemtime( ZAPOMATIC_DIR . 'admin/js/overview-runtime.js' ) ),
            true
        );
        wp_register_script(
            'zapomatic_overview_pt',
            ZAPOMATIC_URL . 'admin/js/overview-products-trends.js',
            array(),
            date( "ymd-Gis", filemtime( ZAPOMATIC_DIR . 'admin/js/overview-products-trends.js' ) ),
            true
        );
        
    }

    public function admin_head() {
        switch ( get_current_screen()->id ) {
            case 'edit-product':
                echo '<style>.zapomatic-toptable .zapomatic-toptabletext { display: none; }</style>';
                break;
            case 'dashboard':
                wp_enqueue_style( 'zapomatic_dashboard_css' );
                wp_enqueue_script( 'zapomatic_chartjs' );
                wp_enqueue_script( 'zapomatic_dashboard_js' );
                break;
            case 'zapomatic_page_zapomatic_settings':
                wp_enqueue_script( 'zapomatic_options_js' );
                break;
            case 'toplevel_page_zapomatic':
                switch ( sanitize_text_field( @$_GET['tab'] ) ) {
                    case 'positions_competitors':
                        wp_enqueue_script( 'zapomatic_chartjs' );
                        wp_enqueue_script( 'zapomatic_overview_pc' );
                        break;
                    case 'runtime':
                        wp_enqueue_script( 'zapomatic_chartjs' );
                        wp_enqueue_script( 'zapomatic_overview_runtime' );
                        break;
                    case 'products_trends':
                        wp_enqueue_script( 'zapomatic_chartjs' );
                        wp_enqueue_script( 'zapomatic_overview_pt' );
                        break;
                    default:
                        wp_enqueue_script( 'zapomatic_overview' );
                        break;
                }
                break;
        }

    }

    public function admin_footer() {

        if ( get_current_screen()->id == 'edit-product' ) {
            wp_enqueue_style( 'zapomatic_edit_products_css' );
        }
        elseif ( get_current_screen()->id == 'toplevel_page_zapomatic' ) {
            wp_enqueue_style( 'zapomatic_overview_css' );
        }
        elseif ( get_current_screen()->id == 'zapomatic_page_zapomatic_tools' ) {
            wp_enqueue_style( 'zapomatic_tools_css' );
            if ( isset( $_GET['tab'] ) && $_GET['tab'] === 'import-data' ) {
                echo '<form id="zapomatic_import_data" method="post" enctype="multipart/form-data"></form>';
                wp_enqueue_script( 'zapomatic_import_data' );
            }
            elseif ( isset( $_GET['tab'] ) && $_GET['tab'] === 'advanced' ) {
            }
            else {
                echo '<form id="zapomatic_import_models" method="post" enctype="multipart/form-data"></form>';
                wp_enqueue_script( 'zapomatic_import_models' );
            }
        }

    }

    public function menu_overview_callback() {

        $this->init_overview();
        $this->overview->print_overview();

    }

    protected function init_tools() {

        if ( $this->tools ) return;
        require_once 'includes/class-tools.php';
        $this->tools = new Zapomatic_Tools;
        return;

    }

    public function menu_tools_callback() {

        $this->tools->print_tools();

    }

    protected function init_overview() {

        if ( $this->overview ) return;
        require_once( 'includes/class-overview.php' );
        $this->overview = new Zapomatic_Overview;
        return;

    }

    public function menu_settings_callback() {
    ?>
    <div class="wrap">
        <h1><?php _e( 'הגדרות זאפומטיק', 'zapomatic' ); ?></h1>
    <?php
    settings_errors();
    ?>
        <nav class="nav-tab-wrapper woo-nav-tab-wrapper">
            <button id="zapomatic_options_tab_zapbott" class="nav-tab nav-tab-active" style="cursor:pointer;"><?php _e('רובוט מחירים', 'zapomatic'); ?></button>
            <button id="zapomatic_options_tab_zapmirror" class="nav-tab" style="cursor:pointer;"><?php _e('אתר מראה', 'zapomatic'); ?></button>
            <button id="zapomatic_options_tab_marketplace" class="nav-tab" style="cursor:pointer;"><?php _e('מרקטפלייס', 'zapomatic'); ?></button>
            <button id="zapomatic_options_tab_license" class="nav-tab" style="cursor:pointer;"><?php _e('רישיון', 'zapomatic'); ?></button>
        </nav>
        <form method="post" action="options.php">
        <?php
        settings_fields( 'zapomatic_settings_group' ); 
        do_settings_sections( 'zapomatic_settings_group' );
        $zapmirror_options = get_option('zapmirror_options');
        $zapmarketplace_options = get_option('zapmarketplace_options');
        ?>
        <div style="display:none;" id="zapomatic_options_license">
        <h2><?php _e( 'הגדרות רישיון', 'zapomatic' ); ?></h2>
        <table class="form-table">
        <tr valign="top">
            <th scope="row"><?php _e( 'טוקן', 'zapomatic'); ?></th>
            <td>
                <?php
                $token = get_option( 'zapomatic_token', null );
                printf(
                    '<input type="text" id="zapomatic-subscription-token" value="%s" readonly="readonly" style="border-color:lightgreen;display:%s;" />',
                    $token,
                    ! $token ? 'none' : 'block'
                );
                printf(
                    '<input type="text" id="zapomatic-subscription-username" placeholder="%s" style="display:%s;" />',
                    esc_attr( __( 'שם משתמש / כתובת דוא"ל', 'zapomatic' ) ),
                    $token ? 'none' : 'block'
                );
                printf(
                    '<input type="password" id="zapomatic-subscription-password" placeholder="%s" style="display:%s;" />',
                    esc_attr( __( 'סיסמה', 'zapomatic' ) ),
                    $token ? 'none' : 'block'
                );
                printf(
                    '<button id="zapomatic-subscription-activate" class="button" style="display:%s;">%s</button>',
                    $token ? 'none' : 'block',
                    __( 'הפעל', 'zapomatic' )
                );
                printf(
                    '<button id="zapomatic-subscription-deactivate" class="button" style="display:%s;">%s</button>',
                    ! $token ? 'none' : 'block',
                    __( 'כבה', 'zapomatic' )
                );
                ?>
                
                <?php
                if ( empty( $token ) ) {
                    printf(
                        '<p>%s.<br />%s, <a target="_blank" href="https://tovel.co.il/product/zapomatic/">%s</a></p>',
                        __( 'הזן את שם המשתמש/אימייל והסיסמה המשוייכים למנוי', 'zapomatic' ),
                        __( 'אם אין ברשותך מנוי', 'zapomatic' ),
                        __( 'לחץ כאן כדי לרכוש', 'zapomatic' )
                    );
                }
                else {
                    global $zapomatic_validator;
                    $subscription_data = $zapomatic_validator->get_data();
                    if ( ! isset( $subscription_data['data'] ) ) {
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s:</th>
                            <td><input type="text" readonly value="%s" /></td>
                            </tr>',
                            __( 'שגיאת רישיון', 'zapomatic' ),
                            $subscription_data['message'],
                        );
                    }
                    else {
                        $this->init_overview();
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s:</th>
                            <td><input type="text" readonly value="%s" /></td>
                            </tr>',
                            __( 'שם חבילה', 'zapomatic' ),
                            esc_attr( $subscription_data['data']['name'] ),
                        );
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s:</th>
                            <td><input type="text" readonly value="%s" /></td>
                            </tr>',
                            __( 'תאריך התחלה', 'zapomatic' ),
                            $this->overview->get_formatted_datetime( $subscription_data['data']['created_date']['date'] ),
                        );
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s:</th>
                            <td><input type="text" readonly value="%s" /></td>
                            </tr>',
                            __( 'תאריך חיוב הבא', 'zapomatic' ),
                            $this->overview->get_formatted_datetime( $subscription_data['data']['next_payment_date'] ),
                        );
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s</th>
                            <td>
                            <input type="checkbox" id="zapomatic-autorenew-cb" disabled="disabled" %s />
                            <button id="zapomatic-activate-autorenew" rel="on" class="button" style="display:%s;">%s</button>
                            <button id="zapomatic-deactivate-autorenew" rel="off" class="button" style="display:%s;">%s</button>
                            </td>
                            </tr>',
                            __( 'חידוש אוטומטי', 'zapomatic' ),
                            $subscription_data['data']['is_manual'] ? null : 'checked',
                            $subscription_data['data']['is_manual'] ? 'inline-block' : 'none',
                            __( 'הפעל', 'zapomatic' ),
                            ! $subscription_data['data']['is_manual'] ? 'inline-block' : 'none',
                            __( 'כבה', 'zapomatic' ),
                        );
                        $zapomatic_assigned_models = $this->get_assigned_models_quantity();
                        $subscription_data_limit = $subscription_data['data']['limit'] == -1 ? 9999999 : (int) $subscription_data['data']['limit'];
                        $subscription_models_diff = $subscription_data_limit - $zapomatic_assigned_models;
                        if ( $zapomatic_assigned_models > $subscription_data_limit ) $zapomatic_assigned_models_border = 'red';
                        if ( $zapomatic_assigned_models == $subscription_data_limit ) $zapomatic_assigned_models_border = 'orange';
                        elseif ( $subscription_models_diff <= 10 ) $zapomatic_assigned_models_border = 'orange';
                        else $zapomatic_assigned_models_border = 'lightgreen';
                        printf(
                            '<tr valign="top">
                            <th scope="row">%s:</th>
                            <td><input type="text" readonly style="width:75px;text-align:center;border-color:%s;" value="%d" title="%s" /> %s</td>
                            </tr>',
                            __( 'מוצרים מוגדרים לרובוט', 'zapomatic' ),
                            esc_attr( $zapomatic_assigned_models_border ),
                            esc_attr( $zapomatic_assigned_models ),
                            esc_attr( sprintf( '%d/%s', $zapomatic_assigned_models, $subscription_data['data']['limit'] == -1 ? '∞' : $subscription_data['data']['limit'] ) ),
                            __( 'מוצרים', 'zapomatic' )
                        );
                    }
                }
                ?>
            </td>
        </tr>
            </table>
            </div>
            <div id="zapomatic_options_zapbott">
            <h2><?php _e( 'הגדרות רובוט מחירים', 'zapomatic' ); ?></h2>
            <table class="form-table">
            <tr valign="top">
                <th scope="row"><?php _e( 'מצב רובוט', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_enabled" >
                        <?php
                        $zapbott_option_enabled = esc_attr( get_option('zapbott_option_enabled') );
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_enabled == 'off' ? 'selected' : '',
                            __( 'כבוי', 'zapomatic ')
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_enabled == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic' )
                        );
                        ?>
                    </select>
                </td> 
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'מזהה החנות בזאפ', 'zapomatic'); ?> (siteid)</th>
                <td><input type="text" name="zapbott_option_siteid" value="<?php echo esc_attr( get_option('zapbott_option_siteid') ); ?>" /></td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'תדירות סריקה', 'zapomatic'); ?></th>
                <td>
                    <select name="zapbott_option_scrap_freq" >
                        <?php
                        $zapbott_option_scrap_freq = esc_attr( get_option('zapbott_option_scrap_freq') );
                        printf(
                            '<option value="auto" %s>%s</option>',
                            $zapbott_option_scrap_freq == 'auto' ? 'selected' : '',
                            __( 'אוטומטי','zapomatic' )
                        );
                        printf(
                            '<option value="24hour" %s>%s</option>',
                            $zapbott_option_scrap_freq == '24hour' ? 'selected' : '',
                            __( 'פעם ביום','zapomatic' )
                        );
                        printf(
                            '<option value="12hour" %s>%s</option>',
                            $zapbott_option_scrap_freq == '12hour' ? 'selected' : '',
                            __( 'פעמיים ביום','zapomatic' )
                        );
                        printf(
                            '<option value="8hour" %s>%s</option>',
                            $zapbott_option_scrap_freq == '8hour' ? 'selected' : '',
                            __( '3 פעמים ביום','zapomatic' )
                        );
                        printf(
                            '<option value="6hour" %s>%s</option>',
                            $zapbott_option_scrap_freq == '6hour' ? 'selected' : '',
                            __( '4 פעמים ביום','zapomatic' )
                        );
                        printf(
                            '<option value="4hour" %s>%s</option>',
                            $zapbott_option_scrap_freq == '4hour' ? 'selected' : '',
                            __( '6 פעמים ביום','zapomatic' )
                        );
                        ?>
                    </select>
                    <?php printf( '<p>%s</p>', __('לאחר שינוי תדירות קבועה, מועד הסריקה הבא יחול בעוד שעתיים', 'zapomatic') ); ?>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'זמן המתנה בין מוצרים במהלך סריקה מלאה', 'zapomatic' ); ?></th>
                <td>
                <?php
                $zapbott_option_scrap_sleep = esc_attr( @get_option( 'zapbott_option_scrap_sleep' ) );
                printf(
                    '<input type="number" name="zapbott_option_scrap_sleep" style="width:50px;" min="2" placeholder="3" value="%s" /> %s<p>%s</p>',
                    $zapbott_option_scrap_sleep,
                    __( 'שניות','zapomatic' ),
                    __( 'להפחתת העומס מהשרת ומשרתי זאפ במהלך סריקה מלאה','zapomatic' )
                );
                ?>
                </td> 
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'מעצורים', 'zapomatic' ); ?></th>
                <td>
                    <?php
                    $zapbott_option_autorestart = esc_attr( @get_option( 'zapbott_option_autorestart' ) );
                    printf('%s <input type="number" name="zapbott_option_autorestart" style="width:55px;" min="0" max="50" placeholder="5" value="%s" /> %s',
                        __( 'נסה','zapomatic'),
                        empty( $zapbott_option_autorestart ) ? null : $zapbott_option_autorestart,
                        __( 'פעמים להחיות סריקה מלאה שנעצרה','zapomatic')
                    );
                    ?>
                </td> 
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'דלג על מוצרים המוסתרים באתר המראה לזאפ', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_skiphidden" >
                        <?php
                        $zapbott_option_skiphidden = get_option('zapbott_option_skiphidden');
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_skiphidden == 'off' ? 'selected' : '',
                            __( 'כבוי','zapomatic' )
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_skiphidden == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic' )
                        );
                        ?>
                    </select>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'דלג על מוצרים שאינם במלאי', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_skipoutofstock" >
                        <?php
                        $zapbott_option_skipoutofstock = get_option('zapbott_option_skipoutofstock');
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_skipoutofstock == 'off' ? 'selected' : '',
                            __( 'כבוי', 'zapomatic' )
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_skipoutofstock == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic' )
                        );
                        ?>
                    </select>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'סרוק מחדש מוצר לאחר עדכון ערכים', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_autoupdatesingle" >
                        <?php
                        $zapbott_option_autoupdatesingle = esc_attr( get_option('zapbott_option_autoupdatesingle') );
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_autoupdatesingle == 'off' ? 'selected' : '',
                            __( 'כבוי', 'zapomatic' )
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_autoupdatesingle == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic' )
                        );
                        ?>
                    </select>
                </td> 
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'שלח דו"ח סיכום למייל בתום סריקה', 'zapomatic' ); ?></th>
                <td>
                    <select id="zapbott_option_sendreport" name="zapbott_option_sendreport" >
                        <?php
                        $zapbott_option_sendreport = esc_attr( get_option('zapbott_option_sendreport') );
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_sendreport == 'off' ? 'selected' : '',
                            __( 'כבוי','zapomatic' )
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_sendreport == 'on' ? 'selected' : '',
                            __( 'פעיל','zapomatic' )
                        );
                        ?>
                    </select>
                    <?php
                    $zapbott_option_sendreport_mail = esc_attr( get_option( 'zapbott_option_sendreport_mail' ) );
                    printf(
                        '<input type="email" name="zapbott_option_sendreport_mail" id="zapbott_option_sendreport_mail"  %s placeholder="%s" value="%s" /><br /><br />',
                        $zapbott_option_sendreport == 'off' ? 'style="display:none;"' : '',
                        esc_attr( get_option( 'admin_email' ) ),
                        !empty($zapbott_option_sendreport_mail) ? $zapbott_option_sendreport_mail : ''
                    );
                    $zapbott_option_sendreport_type = esc_attr( get_option('zapbott_option_sendreport_type') );
                    $zapbott_option_sendreport_type_custom = esc_attr( get_option('zapbott_option_sendreport_type_custom') );
                    printf(
                        '<div id="zapbott_option_sendreport_type" %s>',
                        $zapbott_option_sendreport == 'off' ? 'style="display:none;"' : null
                    );
                        printf(
                            '<input type="radio" name="zapbott_option_sendreport_type" %s value="full"  /><label>%s</label><br />',
                            $zapbott_option_sendreport_type == "full" || empty( $zapbott_option_sendreport_type ) ? esc_attr('checked') : '',
                            __( 'מלא - עבור כל השגיאות והעדכונים','zapomatic' )
                        );
                        printf(
                            '<input type="radio" name="zapbott_option_sendreport_type" %s value="errors"  /><label>%s</label><br />',
                            $zapbott_option_sendreport_type == "errors" ? esc_attr('checked') : '',
                            __( 'מינימלי - רק אם התגלו שגיאות בסריקה או עדכון המוצרים','zapomatic' )
                        );
                        printf(
                            '<input type="radio" name="zapbott_option_sendreport_type" %s value="custom"  /><label>%s</label> ',
                            $zapbott_option_sendreport_type == "custom" ? esc_attr('checked') : '',
                            __( 'מותאם - רק אם התגלו שגיאות או פערי מחיר של לפחות ','zapomatic' )
                        );
                        printf(
                            '<input type="number" name="zapbott_option_sendreport_type_custom" style="width:55px;" min="2" placeholder="2" value="%s" /><label>₪</label>',
                            !empty( $zapbott_option_sendreport_type_custom ) ? $zapbott_option_sendreport_type_custom : null
                        );
                    ?>
                    </div>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'היסטוריית סריקות', 'zapomatic' ); ?></th>
                <td>
                    <?php
                    $zapbott_option_log_history_limit = esc_attr( @get_option( 'zapbott_option_log_history_limit' ) );
                    printf('%s <input type="number" name="zapbott_option_log_history_limit" style="width:55px;" min="0" max="36" placeholder="24" value="%s"> %s',
                        __( 'שמור היסטוריית סריקות של','zapomatic' ),
                        empty( $zapbott_option_log_history_limit ) ? null : $zapbott_option_log_history_limit,
                        __( 'החודשים האחרונים','zapomatic' )
                    );
                    ?>
                </td> 
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'מצב קנייה חכמה בלבד', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_smartonly" >
                        <?php
                        $zapbott_option_smartonly = esc_attr( get_option( 'zapbott_option_smartonly' ) );
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option_smartonly == 'off' ? 'selected' : '',
                            __( 'כבוי','zapomatic' )
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option_smartonly == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic' )
                        );
                        ?>
                    </select>
                    <p><?php _e( 'התעלם מכל החנויות שאינן בעלות תו "קנייה חכמה" בזאפ', 'zapomatic' ); ?></p>
                    <input type="checkbox" id="zapbott_option_smartonly_alt" name="zapbott_option_smartonly_alt" value="on" <?php if ( esc_attr( @get_option('zapbott_option_smartonly_alt') ) ) echo 'checked'; ?>>
                    <label for="zapbott_option_smartonly_alt"><?php _e( 'במידה ולא נמצאו חנויות בעלות התו - סרוק מחדש מבלי להתעלם', 'zapomatic' ); ?></label><br>
                </td>
            </tr>
            
            <tr valign="top">
                <th scope="row"><?php _e( 'התעלם מקנייה דרך זאפ', 'zapomatic' ); ?></th>
                <td>
                    <select name="zapbott_option_nozapbuy" >
                        <?php
                        $zapbott_option__nozapbuy = esc_attr( get_option('zapbott_option_nozapbuy') );
                        printf(
                            '<option value="off" %s>%s</option>',
                            $zapbott_option__nozapbuy == 'off' ? 'selected' : '',
                            __( 'כבוי','zapomatic')
                        );
                        printf(
                            '<option value="on" %s>%s</option>',
                            $zapbott_option__nozapbuy == 'on' ? 'selected' : '',
                            __( 'פעיל', 'zapomatic')
                        );
                        ?>
                    </select>
                    <p><?php _e( 'התעלם מכל החנויות שמוכרות מוצרים דרך זאפ.<br />במידה וחנות מוכרת מוצר גם דרך זאפ וגם דרך החנות - רק החנות תוצג ותילקח בחשבון.', 'zapomatic' ); ?></p>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e('התעלם מחנויות', 'zapomatic'); ?></th>
                <td>
                    <input type="text" name="zapbott_option_excludes" value="<?php echo esc_attr( get_option('zapbott_option_excludes') ); ?>" />
                    <p><?php _e( 'יש להזין את מזהי החנויות (siteid) מופרדים ברווח.<br />לדוגמה: 5832 48592 58219', 'zapomatic' ) ?></p>
                </td>
            </tr>
            <tr valign="top">
                <th scope="row"><?php _e( 'בדיקת תקשורת עם זאפ', 'zapomatic' ); ?></th>
                <td>
                    <textarea id="zapbott-test-input"  value="" style="direction:ltr;" cols="50" readonly="readonly"></textarea>
                    <br /><a id="zapbott-test-btn" class="button"><?php _e( 'בדוק', 'zapomatic' ); ?></a>
                </td>
            </tr>
            </table>
        </div>
        <div style="display:none;" id="zapomatic_options_marketplace">
            <h2><?php _e( 'הגדרות מרקטפלייס', 'zapomatic' ); ?></h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php _e( 'זמן הכנת/אריזת המשלוח (בימים)', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_time2ship]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_time2ship'] == "" ? 'checked' : '',
                            __( 'לא הוגדר','zapomatic' )
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_time2ship]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_time2ship'] == "fixed" ? 'checked' : '',
                            __( 'ערך קבוע','zapomatic' )
                        );
                        printf(
                            '<input type="number" id="marketplace_global_time2ship_fixed" name="zapmarketplace_options[marketplace_global_time2ship_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_time2ship_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_time2ship_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_time2ship]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_time2ship'] == "meta" ? 'checked' : '',
                            __( 'השתמש במפתח מטא','zapomatic' )   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_time2ship_meta" name="zapmarketplace_options[marketplace_global_time2ship_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_time2ship_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_time2ship_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_time2ship]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_time2ship'] == "attribute" ? 'checked' : '',
                            __( 'בחר מתוך תכונות מוצר','zapomatic' )
                            
                        );
                        $attributes = wc_get_attribute_taxonomies();
    
                        if ( $attributes ) {
                            printf(
                                ' <select id="marketplace_global_time2ship_attribute" name="zapmarketplace_options[marketplace_global_time2ship_attribute]" >'
                            );
                            foreach ( $attributes as $attribute ) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_time2ship_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf( '</select>' );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'מצב המוצר', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            ' <select id="marketplace_global_condition" name="zapmarketplace_options[marketplace_global_condition]" >'
                        );
                        printf(
                            '<option value="חדש" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_condition'] == "חדש" ? 'selected' : '',
                            __('חדש','zapomatic')
    
                        );
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'מספר תשלומים מקסימלי (ללא ריבית והצמדה)', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxinstallments]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_maxinstallments'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxinstallments]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_maxinstallments'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="number" id="marketplace_global_maxinstallments_fixed" name="zapmarketplace_options[marketplace_global_maxinstallments_fixed]" min="1" max="36" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_maxinstallments_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_maxinstallments_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxinstallments]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_maxinstallments'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_maxinstallments_meta" name="zapmarketplace_options[marketplace_global_maxinstallments_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_maxinstallments_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_maxinstallments_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxinstallments]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_maxinstallments'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if( $attributes ) {
                            printf(
                                ' <select id="marketplace_global_maxinstallments_attribute" name="zapmarketplace_options[marketplace_global_maxinstallments_attribute]" >'
                            );
                            foreach ( $attributes as $attribute ) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_maxinstallments_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'האם ניתן לבצע איסוף מהחנות', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            ' <select id="marketplace_global_pickup" name="zapmarketplace_options[marketplace_global_pickup]" >'
                        );
                        printf(
                            '<option value="false" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_pickup'] == "false" ? 'selected' : '',
                            __('לא','zapomatic')
    
                        );
                        printf(
                            '<option value="true" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_pickup'] == "true" ? 'selected' : '',
                            __('כן','zapomatic')
    
                        );
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'כמות מלאי המוצר', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_stockquantity]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_stockquantity'] == "" ? 'checked' : '',
                            __('ברירת המחדל של ווקומרס','zapomatic')
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_stockquantity]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_stockquantity'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_stockquantity_meta" name="zapmarketplace_options[marketplace_global_stockquantity_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_stockquantity_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_stockquantity_meta'] ) : ''
                        );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'התראת כמות מלאי מינימלית', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_minquantityalert]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_minquantityalert'] == "" ? 'checked' : '',
                            __('ברירת המחדל של ווקומרס','zapomatic')
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_minquantityalert]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_minquantityalert'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="number" id="marketplace_global_minquantityalert_fixed" min="1" name="zapmarketplace_options[marketplace_global_minquantityalert_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_minquantityalert_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_minquantityalert_fixed']) : ''
                        );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'כמות מקסימלית לרכישה בהזמנה בודדת', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxitemsinorder]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_maxitemsinorder'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxitemsinorder]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_maxitemsinorder'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="number" id="marketplace_global_maxitemsinorder_fixed" name="zapmarketplace_options[marketplace_global_maxitemsinorder_fixed]" min="1" max="36" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_maxitemsinorder_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_maxitemsinorder_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxitemsinorder]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_maxitemsinorder'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_maxitemsinorder_meta" name="zapmarketplace_options[marketplace_global_maxitemsinorder_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_maxitemsinorder_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_maxitemsinorder_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_maxitemsinorder]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_maxitemsinorder'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_maxitemsinorder_attribute" name="zapmarketplace_options[marketplace_global_maxitemsinorder_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_maxitemsinorder_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'שם היבואן', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_importer]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_importer'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_importer]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_importer'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="text" id="marketplace_global_importer_fixed" name="zapmarketplace_options[marketplace_global_importer_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_importer_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_importer_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_importer]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_importer'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_importer_meta" name="zapmarketplace_options[marketplace_global_importer_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_importer_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_importer_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_importer]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_importer'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_importer_attribute" name="zapmarketplace_options[marketplace_global_importer_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_importer_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'תיאור מלא של המוצר (עד 2000 תווים כולל רווחים)', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_description]" %s value="long"  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_description'] == "long" || $zapmarketplace_options['marketplace_global_description'] == "" ? 'checked' : '',
                            __('השתמש בתיאור המלא','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_description]" %s value="short"  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_description'] == "short" ? 'checked' : '',
                            __( 'השתמש בתיאור הקצר','zapomatic' )
                                
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_description]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_description'] == "meta" ? 'checked' : '',
                            __( 'השתמש במפתח מטא','zapomatic' )   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_description_meta" name="zapmarketplace_options[marketplace_global_description_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_description_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_description_meta'] ) : ''
                        );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'תנאי רכישה ואחריות', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_terms]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_terms'] == "" ? 'checked' : '',
                            __( 'לא הוגדר', 'zapomatic' )
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_terms]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_terms'] == "meta" ? 'checked' : '',
                            __( 'השתמש במפתח מטא', 'zapomatic' )   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_terms_meta" name="zapmarketplace_options[marketplace_global_terms_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_terms_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_terms_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_terms]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_terms'] == "attribute" ? 'checked' : '',
                            __( 'בחר מתוך תכונות מוצר', 'zapomatic' )
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_terms_attribute" name="zapmarketplace_options[marketplace_global_terms_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_terms_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select><br />');
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_terms]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_terms'] == "fixed" ? 'checked' : '',
                            __( 'ערך קבוע','zapomatic' )
                        );
                        printf(
                            '<br /><textarea id="marketplace_global_terms_fixed" name="zapmarketplace_options[marketplace_global_terms_fixed]" cols="43" rows="5">%s</textarea>',
                            isset( $zapmarketplace_options['marketplace_global_terms_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_terms_fixed']) : ''
                        );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'דירוג לוגיסטי של המשלוח', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_logistic]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_logistic'] == "fixed" || ! $zapmarketplace_options['marketplace_global_logistic'] ? 'checked' : '',
                            __( 'ערך קבוע' , 'zapomatic' )
                        );
                        printf(
                            ' <select id="marketplace_global_logistic_fixed" name="zapmarketplace_options[marketplace_global_logistic_fixed]" >'
                        );
                        printf(
                            '<option value="FREE-HOME" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "FREE-HOME" ? 'selected' : '',
                            __( 'משלוח חינם עד הבית', 'zapomatic' )
    
                        );
                        printf(
                            '<option value="EX_S" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "EX_S" ? 'selected' : '',
                            __( 'עד 2.5 ק"ג, (מתאים ללוקרים ונקודות איסוף)', 'zapomatic' )
    
                        );
                        printf(
                            '<option value="S" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "S" ? 'selected' : '',
                            __( 'עד 5 ק"ג, גובה מקסימלי 30 ס"מ (מתאים ללוקרים ונקודות איסוף)', 'zapomatic' )
    
                        );
                        printf(
                            '<option value="M" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "M" ? 'selected' : '',
                            __( 'עד 5 ק"ג, גובה מקסימלי 60 ס"מ (מתאים לשליח עד הבית בלבד)', 'zapomatic' )
    
                        );
                        printf(
                            '<option value="L" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "L" ? 'selected' : '',
                            __('5-20 ק"ג, גובה מקסימלי 80 ס"מ (מתאים לשליח עד הבית בלבד)','zapomatic')
    
                        );
    
                        printf(
                            '<option value="OV" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "OV" ? 'selected' : '',
                            __( 'פריטים במשקל של 20 ק"ג ומעלה (מוצרים חריגים והובלות מיוחדות)', 'zapomatic' )
    
                        );
                        printf(
                            '<option value="SPD" %s>%s</option>',
                            $zapmarketplace_options['marketplace_global_logistic_fixed'] == "SPD" ? 'selected' : '',
                            __( 'מוצרים חריגים (באישור מנהל הסחר בלבד)', 'zapomatic' )
    
                        );
                        printf('</select><br />');
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_logistic]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_logistic'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_logistic_meta" name="zapmarketplace_options[marketplace_global_logistic_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_logistic_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_logistic_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_logistic]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_logistic'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_logistic_attribute" name="zapmarketplace_options[marketplace_global_logistic_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_logistic_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select><br />');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'תיאור עשיר על המוצר (עד 5000 תווים כולל רווחים)', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_paraminfo]" %s value="long"  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_paraminfo'] == "long" || $zapmarketplace_options['marketplace_global_paraminfo'] == "" ? 'checked' : '',
                            __( 'השתמש בתיאור המלא','zapomatic' )
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_paraminfo]" %s value="short"  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_paraminfo'] == "short" ? 'checked' : '',
                            __( 'השתמש בתיאור הקצר','zapomatic' )
                                
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_paraminfo]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_paraminfo'] == "meta" ? 'checked' : '',
                            __( 'השתמש במפתח מטא','zapomatic' )   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_paraminfo_meta" name="zapmarketplace_options[marketplace_global_paraminfo_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_paraminfo_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_paraminfo_meta'] ) : ''
                        );
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'משך אחריות (בחודשים)', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warranty]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_warranty'] == "" ? 'checked' : '',
                            __( 'לא הוגדר','zapomatic' )
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warranty]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_warranty'] == "fixed" ? 'checked' : '',
                            __( 'ערך קבוע','zapomatic' )
                        );
                        printf(
                            '<input type="number" id="marketplace_global_warranty_fixed" name="zapmarketplace_options[marketplace_global_warranty_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_warranty_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_warranty_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warranty]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_warranty'] == "meta" ? 'checked' : '',
                            __( 'השתמש במפתח מטא','zapomatic' )   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_warranty_meta" name="zapmarketplace_options[marketplace_global_warranty_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_warranty_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_warranty_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warranty]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_warranty'] == "attribute" ? 'checked' : '',
                            __( 'בחר מתוך תכונות מוצר', 'zapomatic' )
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
                        if ( $attributes ) {
                            printf(
                                ' <select id="marketplace_global_warranty_attribute" name="zapmarketplace_options[marketplace_global_warranty_attribute]" >'
                            );
                            foreach ( $attributes as $attribute ) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_warranty_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'שם נותן האחריות', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warrantyby]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_warrantyby'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warrantyby]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_warrantyby'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="text" id="marketplace_global_warrantyby_fixed" name="zapmarketplace_options[marketplace_global_warrantyby_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_warrantyby_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_warrantyby_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warrantyby]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_warrantyby'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_warrantyby_meta" name="zapmarketplace_options[marketplace_global_warrantyby_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_warrantyby_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_warrantyby_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_warrantyby]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_warrantyby'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_warrantyby_attribute" name="zapmarketplace_options[marketplace_global_warrantyby_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_warrantyby_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'עלות התקנה/הרכבה', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_installationcost]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_installationcost'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_installationcost]" %s value="fixed"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_installationcost'] == "fixed" ? 'checked' : '',
                            __('ערך קבוע','zapomatic')
                        );
                        printf(
                            '<input type="number" id="marketplace_global_installationcost_fixed" name="zapmarketplace_options[marketplace_global_installationcost_fixed]" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_installationcost_fixed'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_installationcost_fixed']) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_installationcost]" %s value="meta"  /><label>%s</label> ',
                            $zapmarketplace_options['marketplace_global_installationcost'] == "meta" ? 'checked' : '',
                            __('השתמש במפתח מטא','zapomatic')   
                        );
                        printf(
                            '<input type="text" id="marketplace_global_installationcost_meta" name="zapmarketplace_options[marketplace_global_installationcost_meta]" value="%s" /><br>',
                            !empty( $zapmarketplace_options['marketplace_global_installationcost_meta'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_installationcost_meta'] ) : ''
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_installationcost]" %s value="attribute"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_installationcost'] == "attribute" ? 'checked' : '',
                            __('בחר מתוך תכונות מוצר','zapomatic')
                            
                        );
                        $attributes =  wc_get_attribute_taxonomies();
    
                        if($attributes) {
                            printf(
                                ' <select id="marketplace_global_installationcost_attribute" name="zapmarketplace_options[marketplace_global_installationcost_attribute]" >'
                            );
                            foreach ($attributes as $attribute) {
                                printf(
                                '<option value="%s" %s >%s</option>',
                                $attribute->attribute_name,
                                $zapmarketplace_options['marketplace_global_installationcost_attribute'] == $attribute->attribute_name ? 'selected' : '',
                                $attribute->attribute_label
                            );
                            }
                        }
                        printf('</select>');
                        ?>
                    </td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><?php _e( 'מוצרים נלווים למוצר', 'zapomatic' ); ?></th>
                    <td>
                        <?php
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_relatedproducts]" %s value=""  /><label>%s</label><br>',
                            $zapmarketplace_options['marketplace_global_relatedproducts'] == "" ? 'checked' : '',
                            __('לא הוגדר','zapomatic')
                            
                        );
                        printf(
                            '<input type="radio" name="zapmarketplace_options[marketplace_global_relatedproducts]" %s value="category"  /><label>%s</label>',
                            $zapmarketplace_options['marketplace_global_relatedproducts'] == "category" ? 'checked' : '',
                            __('בחר אקראית מקטגוריית המוצר','zapomatic')
                        );
                        printf(
                            '<br /><label for="marketplace_global_relatedproducts_limit">%s</label> ',
                            __('כמות מוצרים מקסימלית:','zapomatic')
                        );
                        printf(
                            '<input type="number" id="marketplace_global_relatedproducts_limit" name="zapmarketplace_options[marketplace_global_relatedproducts_limit]" min="0" value="%s" /><br>',
                            isset( $zapmarketplace_options['marketplace_global_relatedproducts_limit'] ) ? esc_attr( $zapmarketplace_options['marketplace_global_relatedproducts_limit']) : ''
                        );
                        echo wc_help_tip( __( 'ניתן להשאיר ריק בכדי להציג את כלל המוצרים הנלווים מהקטגוריה', 'zapomatic' ) );
                        ?>
                    </td> 
                </tr>
            </table>
        </div>
        <div style="display:none;" id="zapomatic_options_zapmirror">
        <h2><?php _e( 'הגדרות אתר מראה', 'zapomatic' ); ?></h2>
        <table class="form-table">
        <tr valign="top">
                <th scope="row"><?php _e( 'עמוד מראה לזאפ', 'zapomatic' ); ?></th>
                <td>
                    <select id="zapmirror_mirror_page" name="zapmirror_options[mirror_page]" >
                        <option value=""></option>
                        <?php
                        $pages = get_pages();
                        foreach ($pages as $page) {
                            printf(
                            '<option value="%s" %s >%s</option>',
                            $page->ID,
                            $zapmirror_options['mirror_page'] == $page->ID ? esc_attr('selected') : '',
                            $page->post_title
                        );
                    }
                        ?>
                    </select>
                </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'הסתר קטגוריות', 'zapomatic' ); ?></th>
                <td>
                <style type="text/css">
                    ul.children { margin-right:25px; }
                </style>
        <?php
                $selected_cat = explode(",",$zapmirror_options['zapmirror_hide_category']);
                echo '<div id="zapmirror_categories_to_skip" class="tabs-panel">
                           <ul id="zap-product_catchecklist" data-wp-lists="list:product_cat" class="categorychecklist form-no-clear" style="margin:0;">';
                echo str_replace(
                                   'tax_input[product_cat]', 
                                   'zapmirror_options[zapmirror_hide_category]', 
                                   wp_terms_checklist(
                                    $zapmirror_options['mirror_page'], 
                                       array(
                                           'selected_cats'	=> $selected_cat,
                                           'taxonomy' 		=> 'product_cat',
                                           'echo' 			=> false
                                       )
                                   )
                               ); 
               echo '</ul></div>';
        ?>
        </td>
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'הסתר מוצרים לפי מחיר', 'zapomatic' ); ?></th>
                <td>
                    <?php
                    printf(
                        '%s <input type="number" name="zapmirror_options[zapmirror_hide_products_price]" style="width:65px;" min="0" value="%s">₪ %s',
                    __( 'הסתר מוצרים שמחירם','zapomatic'),
                    isset( $zapmirror_options['zapmirror_hide_products_price'] ) ? esc_attr( $zapmirror_options['zapmirror_hide_products_price'] ) : '',
                    __( 'ומטה','zapomatic'),
                    );
                    ?>
                </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'תיאור מוצר', 'zapomatic' ); ?></th>
                <td>
        <?php
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_description]" %s value="short"  /><label>%s</label><br>',
            $zapmirror_options['zapmirror_global_description'] == "short" ? 'checked' : '',
            __('השתמש בתיאור הקצר','zapomatic')
                
        );
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_description]" %s value="long"  /><label>%s</label><br>',
            $zapmirror_options['zapmirror_global_description'] == "long" ? 'checked' : '',
            __('השתמש בתיאור המלא','zapomatic')
            
        );
    
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_description]" %s value="meta"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_description'] == "meta" ? 'checked' : '',
            __('השתמש במפתח מטא','zapomatic')   
        );
        printf(
            '<input type="text" id="zapmirror_global_description_meta" name="zapmirror_options[zapmirror_global_description_meta]" value="%s" /><br>',
            !empty( $zapmirror_options['zapmirror_global_description_meta'] ) ? esc_attr( $zapmirror_options['zapmirror_global_description_meta'] ) : ''
        );
    
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_description]" %s value="fixed"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_description'] == "fixed" ? 'checked' : '',
            __('השתמש בטקסט קבוע','zapomatic')   
        );
        printf(
            '<input type="text" id="zapmirror_global_description_fixed" name="zapmirror_options[zapmirror_global_description_fixed]" value="%s" maxlength="255" /><br>',
            !empty( $zapmirror_options['zapmirror_global_description_fixed'] ) ? esc_attr( $zapmirror_options['zapmirror_global_description_fixed'] ) : ''
        );
    
    
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_description]" %s value="attribute"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_description'] == "attribute" ? 'checked' : '',
            __('בחר מתוך תכונות מוצר','zapomatic')
            
        );
        $attributes =  wc_get_attribute_taxonomies();
        if($attributes) {
            printf(
                ' <select id="zapmirror_global_description_attribute" name="zapmirror_options[zapmirror_global_description_attribute]" >'
            );
            foreach ($attributes as $attribute) {
                printf(
                '<option value="%s" %s >%s</option>',
                $attribute->attribute_name,
                $zapmirror_options['zapmirror_global_description_attribute'] == $attribute->attribute_name ? 'selected' : '',
                $attribute->attribute_label
            );
            }
        }
        printf('</select>');
        ?>
            </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'עלות משלוח', 'zapomatic' ); ?></th>
                <td>
        <?php
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_shipcost]" %s value=""  /><label>%s (0)</label><br>',
            $zapmirror_options['zapmirror_global_shipcost'] == "" ? 'checked' : '',
            __('לא הוגדר','zapomatic')
            
        );
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_shipcost]" %s value="shipping_method"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_shipcost'] == "shipping_method" ? 'checked' : '',
            __('לפי סוג משלוח','zapomatic')   
        );
            $delivery_zones = WC_Shipping_Zones::get_zones();
            foreach ((array) $delivery_zones as $key => $the_zone ) {
            foreach ($the_zone['zone_locations'] as $zone_location) {
                if($zone_location->code == 'IL') {
                    $default_zone = new WC_Shipping_Zone($the_zone['id']);
                }
            }
            }
            if(!$default_zone) {
                $default_zone = new WC_Shipping_Zone(0);
            }
            $shipping_methods = $default_zone->get_shipping_methods();
            printf(
                '<select id="zapmirror_force_shipping_method" name="zapmirror_options[zapmirror_force_shipping_method]" >'
            );
            foreach ($shipping_methods as $shipping_method) {
                $shipping_method_arr = explode('|', $zapmirror_options['zapmirror_force_shipping_method'] );
                printf(
                '<option value="%s" %s >%s</option>',
                sprintf( '%s|%s', $shipping_method->id, $shipping_method->instance_id ),
                $shipping_method_arr[0] == $shipping_method->id && $shipping_method_arr[1] == $shipping_method->instance_id ? 'selected' : '',
                $shipping_method->title
            );
            }
            echo '</select><br>';
            printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_shipcost]" %s value="default"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_shipcost'] == "default" ? 'checked' : '',
            __('ערך קבוע','zapomatic')   
        );
        printf(
            '<input type="number" name="zapmirror_options[zapmirror_global_shipcost_default]" value="%s" /><br>',
            isset( $zapmirror_options['zapmirror_global_shipcost_default'] ) ? esc_attr( $zapmirror_options['zapmirror_global_shipcost_default']) : ''
        );
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_shipcost]" %s value="meta"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_shipcost'] == "meta" ? 'checked' : '',
            __('השתמש במפתח מטא','zapomatic')   
        );
        printf(
            '<input type="text" name="zapmirror_options[zapmirror_global_shipcost_meta]" value="%s" /><br>',
            !empty( $zapmirror_options['zapmirror_global_shipcost_meta'] ) ? esc_attr( $zapmirror_options['zapmirror_global_shipcost_meta'] ) : ''
        );
        printf(
            '%s <input type="number" name="zapmirror_options[zapmirror_global_shipcost__dynamic_shipcost]" style="width:65px;" min="0" value="%s">₪ 
            %s <input type="number" name="zapmirror_options[zapmirror_global_shipcost__dynamic_prodcost]" style="width:75px;" min="1" value="%s">₪',
        __( 'קבע מחיר משלוח על סך','zapomatic'),
        isset( $zapmirror_options['zapmirror_global_shipcost__dynamic_shipcost'] ) ? esc_attr( $zapmirror_options['zapmirror_global_shipcost__dynamic_shipcost'] ) : '',
        __( 'במידה ומחיר המוצר הינו לפחות','zapomatic'),
        isset( $zapmirror_options['zapmirror_global_shipcost__dynamic_prodcost'] ) ? esc_attr( $zapmirror_options['zapmirror_global_shipcost__dynamic_prodcost'] ) : ''
        );
        ?>
    </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'זמן אספקה', 'zapomatic' ); ?></th>
                <td>
    <?php
    printf(
        '<input type="radio" name="zapmirror_options[zapmirror_global_delivery]" %s value=""  /><label>%s (14)</label><br>',
        $zapmirror_options['zapmirror_global_delivery'] == "" ? 'checked' : '',
        __('לא הוגדר','zapomatic')
        
    );
    printf(
        '<input type="radio" name="zapmirror_options[zapmirror_global_delivery]" %s value="text"  /><label>%s</label> ',
        $zapmirror_options['zapmirror_global_delivery'] == "text" ? 'checked' : '',
        __('ערך קבוע','zapomatic')
    );
    printf(
        '<input type="number" id="zapmirror_global_delivery_default" name="zapmirror_options[zapmirror_global_delivery_default]" value="%s" /><br>',
        isset( $zapmirror_options['zapmirror_global_delivery_default'] ) ? esc_attr( $zapmirror_options['zapmirror_global_delivery_default']) : ''
    );
    printf(
        '<input type="radio" name="zapmirror_options[zapmirror_global_delivery]" %s value="meta"  /><label>%s</label> ',
        $zapmirror_options['zapmirror_global_delivery'] == "meta" ? 'checked' : '',
        __('השתמש במפתח מטא','zapomatic')   
    );
    printf(
        '<input type="text" id="zapmirror_global_delivery_meta" name="zapmirror_options[zapmirror_global_delivery_meta]" value="%s" /><br>',
        !empty( $zapmirror_options['zapmirror_global_delivery_meta'] ) ? esc_attr( $zapmirror_options['zapmirror_global_delivery_meta'] ) : ''
    );
    printf(
        '<input type="radio" name="zapmirror_options[zapmirror_global_delivery]" %s value="attribute"  /><label>%s</label>',
        $zapmirror_options['zapmirror_global_delivery'] == "attribute" ? 'checked' : '',
        __('בחר מתוך תכונות מוצר','zapomatic')
        
    );
    $attributes =  wc_get_attribute_taxonomies();
    
    if($attributes) {
        printf(
            ' <select id="zapmirror_global_delivery_attribute" name="zapmirror_options[zapmirror_global_delivery_attribute]" >'
        );
        foreach ($attributes as $attribute) {
            printf(
            '<option value="%s" %s >%s</option>',
            $attribute->attribute_name,
            $zapmirror_options['zapmirror_global_delivery_attribute'] == $attribute->attribute_name ? 'selected' : '',
            $attribute->attribute_label
        );
        }
    }
    printf('</select>');
    ?>
    </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'מק"ט', 'zapomatic' ); ?></th>
                <td>
        <?php
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_catalognumber]" %s value="default"  /><label>%s</label><br>',
            !isset( $zapmirror_options['zapmirror_global_catalognumber'] ) || $zapmirror_options['zapmirror_global_catalognumber'] == "default" ? 'checked' : '',
            __('ברירת מחדל (SKU)','zapomatic')
                
        );
        printf(
            '<input type="radio" name="zapmirror_options[zapmirror_global_catalognumber]" %s value="meta"  /><label>%s</label> ',
            $zapmirror_options['zapmirror_global_catalognumber'] == "meta" ? 'checked' : '',
            __('השתמש במפתח מטא','zapomatic')   
        );
        printf(
            '<input type="text" id="zapmirror_global_catalognumber_meta" name="zapmirror_options[zapmirror_global_catalognumber_meta]" value="%s" /><br>',
            !empty( $zapmirror_options['zapmirror_global_catalognumber_meta'] ) ? esc_attr( $zapmirror_options['zapmirror_global_catalognumber_meta'] ) : ''
        );
        ?>
            </td> 
        </tr>
        <tr valign="top">
                <th scope="row"><?php _e( 'תגיות UTM בקישורים', 'zapomatic' ); ?></th>
                <td>
                    <?php
                    printf(
                        '%s <input type="text" name="zapmirror_options[zapmirror_utm_source]" placeholder="%s" value="%s" /><br>',
                        __('מקור תנועה','zapomatic'),
                        __('לדוגמה: zap','zapomatic'),
                        !empty( $zapmirror_options['zapmirror_utm_source'] ) ? esc_attr( $zapmirror_options['zapmirror_utm_source'] ) : ''
                    );
                    printf(
                        '%s <input type="text" name="zapmirror_options[zapmirror_utm_medium]" placeholder="%s" value="%s" /><br>',
                        __('מדיום שיווקי','zapomatic'),
                        __('לדוגמה: mirror-site','zapomatic'),
                        !empty( $zapmirror_options['zapmirror_utm_medium'] ) ? esc_attr( $zapmirror_options['zapmirror_utm_medium'] ) : ''
                    );
                    ?>
                </td> 
        </tr>
        </table>
        </div>
        <?php submit_button(); ?>
    </form>
    </div>
    <?php
    }

    protected function register_setting_group() {

        register_setting( 'zapomatic_settings_group', 'zapbott_option_enabled', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_siteid', array( 'type' => 'integer', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_scrap_freq', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_scrap_sleep', array( 'type' => 'integer', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_skiphidden', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_skipoutofstock', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_sendreport', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_sendreport_mail', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_email' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_sendreport_type', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_sendreport_type_custom', array( 'type' => 'integer', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_autorestart', array( 'type' => 'integer', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_autoupdatesingle', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_log_history_limit', array( 'type' => 'integer', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_smartonly', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_smartonly_alt', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_nozapbuy', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapbott_option_excludes', array( 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ) );
        register_setting( 'zapomatic_settings_group', 'zapmirror_options', array( $this, 'zapmirror_options_sanitize_callback' ) );
        register_setting( 'zapomatic_settings_group', 'zapmarketplace_options', array( $this, 'zapmarketplace_options_sanitize_callback' ) );
        return;

    }

    public function zapmirror_options_sanitize_callback( $input ) {

        $new_input = array();
        if( isset( $input['mirror_page'] ) ) $new_input['mirror_page'] = sanitize_text_field( $input['mirror_page'] );
        if( isset( $input['zapmirror_hide_category'] ) ) { 
                $input_array = implode(',',$input['zapmirror_hide_category']);
                $new_input['zapmirror_hide_category'] = sanitize_text_field( $input_array );
       }
        if( isset( $input['zapmirror_hide_products_price'] ) ) $new_input['zapmirror_hide_products_price'] = sanitize_text_field( $input['zapmirror_hide_products_price'] );
        if( isset( $input['zapmirror_global_shipcost'] ) ) $new_input['zapmirror_global_shipcost'] = sanitize_text_field( $input['zapmirror_global_shipcost'] );
        if( isset( $input['zapmirror_force_shipping_method'] ) ) $new_input['zapmirror_force_shipping_method'] = sanitize_text_field( $input['zapmirror_force_shipping_method'] );
        if( isset( $input['zapmirror_global_shipcost_default'] ) ) $new_input['zapmirror_global_shipcost_default'] = sanitize_text_field( $input['zapmirror_global_shipcost_default'] );
        if( isset( $input['zapmirror_global_shipcost_meta'] ) ) $new_input['zapmirror_global_shipcost_meta'] = sanitize_text_field( $input['zapmirror_global_shipcost_meta'] );
        if( isset( $input['zapmirror_global_shipcost__dynamic_shipcost'] ) ) $new_input['zapmirror_global_shipcost__dynamic_shipcost'] = sanitize_text_field( $input['zapmirror_global_shipcost__dynamic_shipcost'] );
        if( isset( $input['zapmirror_global_shipcost__dynamic_prodcost'] ) ) $new_input['zapmirror_global_shipcost__dynamic_prodcost'] = sanitize_text_field( $input['zapmirror_global_shipcost__dynamic_prodcost'] );
        if( isset( $input['zapmirror_global_description'] ) ) $new_input['zapmirror_global_description'] = sanitize_text_field( $input['zapmirror_global_description'] );
        if( isset( $input['zapmirror_global_description_attribute'] ) ) $new_input['zapmirror_global_description_attribute'] = sanitize_text_field( $input['zapmirror_global_description_attribute'] );
        if( isset( $input['zapmirror_global_description_meta'] ) ) $new_input['zapmirror_global_description_meta'] = sanitize_text_field( $input['zapmirror_global_description_meta'] );
        if( isset( $input['zapmirror_global_description_fixed'] ) ) $new_input['zapmirror_global_description_fixed'] = sanitize_text_field( $input['zapmirror_global_description_fixed'] );       
        if( isset( $input['zapmirror_global_delivery'] ) ) $new_input['zapmirror_global_delivery'] = sanitize_text_field( $input['zapmirror_global_delivery'] );
        if( isset( $input['zapmirror_global_delivery_attribute'] ) ) $new_input['zapmirror_global_delivery_attribute'] = sanitize_text_field( $input['zapmirror_global_delivery_attribute'] );
        if( isset( $input['zapmirror_global_delivery_meta'] ) ) $new_input['zapmirror_global_delivery_meta'] = sanitize_text_field( $input['zapmirror_global_delivery_meta'] );
        if( isset( $input['zapmirror_global_delivery_default'] ) ) $new_input['zapmirror_global_delivery_default'] = sanitize_text_field( $input['zapmirror_global_delivery_default'] );
        if( isset( $input['zapmirror_global_catalognumber'] ) ) $new_input['zapmirror_global_catalognumber'] = sanitize_text_field( $input['zapmirror_global_catalognumber'] );
        if( isset( $input['zapmirror_global_catalognumber_meta'] ) ) $new_input['zapmirror_global_catalognumber_meta'] = sanitize_text_field( $input['zapmirror_global_catalognumber_meta'] );
        if( isset( $input['zapmirror_utm_source'] ) ) $new_input['zapmirror_utm_source'] = sanitize_text_field( $input['zapmirror_utm_source'] );
        if( isset( $input['zapmirror_utm_medium'] ) ) $new_input['zapmirror_utm_medium'] = sanitize_text_field( $input['zapmirror_utm_medium'] );  
        return $new_input;

    }

    public function zapmarketplace_options_sanitize_callback( $input ) {

        $new_input = array();
        if( isset( $input['marketplace_global_importer'] ) ) $new_input['marketplace_global_importer'] = sanitize_text_field( $input['marketplace_global_importer'] );
        if( isset( $input['marketplace_global_importer_attribute'] ) ) $new_input['marketplace_global_importer_attribute'] = sanitize_text_field( $input['marketplace_global_importer_attribute'] );
        if( isset( $input['marketplace_global_importer_meta'] ) ) $new_input['marketplace_global_importer_meta'] = sanitize_text_field( $input['marketplace_global_importer_meta'] );
        if( isset( $input['marketplace_global_importer_fixed'] ) ) $new_input['marketplace_global_importer_fixed'] = sanitize_text_field( $input['marketplace_global_importer_fixed'] );
        if( isset( $input['marketplace_global_time2ship'] ) ) $new_input['marketplace_global_time2ship'] = sanitize_text_field( $input['marketplace_global_time2ship'] );
        if( isset( $input['marketplace_global_time2ship_attribute'] ) ) $new_input['marketplace_global_time2ship_attribute'] = sanitize_text_field( $input['marketplace_global_time2ship_attribute'] );
        if( isset( $input['marketplace_global_time2ship_meta'] ) ) $new_input['marketplace_global_time2ship_meta'] = sanitize_text_field( $input['marketplace_global_time2ship_meta'] );
        if( isset( $input['marketplace_global_time2ship_fixed'] ) ) $new_input['marketplace_global_time2ship_fixed'] = sanitize_text_field( $input['marketplace_global_time2ship_fixed'] );
        if( isset( $input['marketplace_global_condition'] ) ) $new_input['marketplace_global_condition'] = sanitize_text_field( $input['marketplace_global_condition'] );
        if( isset( $input['marketplace_global_maxinstallments'] ) ) $new_input['marketplace_global_maxinstallments'] = sanitize_text_field( $input['marketplace_global_maxinstallments'] );
        if( isset( $input['marketplace_global_maxinstallments_attribute'] ) ) $new_input['marketplace_global_maxinstallments_attribute'] = sanitize_text_field( $input['marketplace_global_maxinstallments_attribute'] );
        if( isset( $input['marketplace_global_maxinstallments_meta'] ) ) $new_input['marketplace_global_maxinstallments_meta'] = sanitize_text_field( $input['marketplace_global_maxinstallments_meta'] );
        if( isset( $input['marketplace_global_maxinstallments_fixed'] ) ) $new_input['marketplace_global_maxinstallments_fixed'] = sanitize_text_field( $input['marketplace_global_maxinstallments_fixed'] );
        if( isset( $input['marketplace_global_pickup'] ) ) $new_input['marketplace_global_pickup'] = sanitize_text_field( $input['marketplace_global_pickup'] );
        if( isset( $input['marketplace_global_minquantityalert'] ) ) $new_input['marketplace_global_minquantityalert'] = sanitize_text_field( $input['marketplace_global_minquantityalert'] );
        if( isset( $input['marketplace_global_minquantityalert_fixed'] ) ) $new_input['marketplace_global_minquantityalert_fixed'] = sanitize_text_field( $input['marketplace_global_minquantityalert_fixed'] );
        if( isset( $input['marketplace_global_description'] ) ) $new_input['marketplace_global_description'] = sanitize_text_field( $input['marketplace_global_description'] );
        if( isset( $input['marketplace_global_description_meta'] ) ) $new_input['marketplace_global_description_meta'] = sanitize_text_field( $input['marketplace_global_description_meta'] );
        if( isset( $input['marketplace_global_terms'] ) ) $new_input['marketplace_global_terms'] = sanitize_text_field( $input['marketplace_global_terms'] );
        if( isset( $input['marketplace_global_terms_attribute'] ) ) $new_input['marketplace_global_terms_attribute'] = sanitize_text_field( $input['marketplace_global_terms_attribute'] );
        if( isset( $input['marketplace_global_terms_meta'] ) ) $new_input['marketplace_global_terms_meta'] = sanitize_text_field( $input['marketplace_global_terms_meta'] );
        if( isset( $input['marketplace_global_terms_fixed'] ) ) $new_input['marketplace_global_terms_fixed'] = sanitize_text_field( $input['marketplace_global_terms_fixed'] );
        if( isset( $input['marketplace_global_logistic'] ) ) $new_input['marketplace_global_logistic'] = sanitize_text_field( $input['marketplace_global_logistic'] );
        if( isset( $input['marketplace_global_logistic_attribute'] ) ) $new_input['marketplace_global_logistic_attribute'] = sanitize_text_field( $input['marketplace_global_logistic_attribute'] );
        if( isset( $input['marketplace_global_logistic_meta'] ) ) $new_input['marketplace_global_logistic_meta'] = sanitize_text_field( $input['marketplace_global_logistic_meta'] );
        if( isset( $input['marketplace_global_logistic_fixed'] ) ) $new_input['marketplace_global_logistic_fixed'] = sanitize_text_field( $input['marketplace_global_logistic_fixed'] );
        if( isset( $input['marketplace_global_paraminfo'] ) ) $new_input['marketplace_global_paraminfo'] = sanitize_text_field( $input['marketplace_global_paraminfo'] );
        if( isset( $input['marketplace_global_paraminfo_meta'] ) ) $new_input['marketplace_global_paraminfo_meta'] = sanitize_text_field( $input['marketplace_global_paraminfo_meta'] );
        if( isset( $input['marketplace_global_warranty'] ) ) $new_input['marketplace_global_warranty'] = sanitize_text_field( $input['marketplace_global_warranty'] );
        if( isset( $input['marketplace_global_warranty_attribute'] ) ) $new_input['marketplace_global_warranty_attribute'] = sanitize_text_field( $input['marketplace_global_warranty_attribute'] );
        if( isset( $input['marketplace_global_warranty_meta'] ) ) $new_input['marketplace_global_warranty_meta'] = sanitize_text_field( $input['marketplace_global_warranty_meta'] );
        if( isset( $input['marketplace_global_warranty_fixed'] ) ) $new_input['marketplace_global_warranty_fixed'] = sanitize_text_field( $input['marketplace_global_warranty_fixed'] );
        if( isset( $input['marketplace_global_warrantyby'] ) ) $new_input['marketplace_global_warrantyby'] = sanitize_text_field( $input['marketplace_global_warrantyby'] );
        if( isset( $input['marketplace_global_warrantyby_attribute'] ) ) $new_input['marketplace_global_warrantyby_attribute'] = sanitize_text_field( $input['marketplace_global_warrantyby_attribute'] );
        if( isset( $input['marketplace_global_warrantyby_meta'] ) ) $new_input['marketplace_global_warrantyby_meta'] = sanitize_text_field( $input['marketplace_global_warrantyby_meta'] );
        if( isset( $input['marketplace_global_warrantyby_fixed'] ) ) $new_input['marketplace_global_warrantyby_fixed'] = sanitize_text_field( $input['marketplace_global_warrantyby_fixed'] );
        if( isset( $input['marketplace_global_installationcost'] ) ) $new_input['marketplace_global_installationcost'] = sanitize_text_field( $input['marketplace_global_installationcost'] );
        if( isset( $input['marketplace_global_installationcost_attribute'] ) ) $new_input['marketplace_global_installationcost_attribute'] = sanitize_text_field( $input['marketplace_global_installationcost_attribute'] );
        if( isset( $input['marketplace_global_installationcost_meta'] ) ) $new_input['marketplace_global_installationcost_meta'] = sanitize_text_field( $input['marketplace_global_installationcost_meta'] );
        if( isset( $input['marketplace_global_installationcost_fixed'] ) ) $new_input['marketplace_global_installationcost_fixed'] = sanitize_text_field( $input['marketplace_global_installationcost_fixed'] );
        if( isset( $input['marketplace_global_stockquantity'] ) ) $new_input['marketplace_global_stockquantity'] = sanitize_text_field( $input['marketplace_global_stockquantity'] );
        if( isset( $input['marketplace_global_stockquantity_meta'] ) ) $new_input['marketplace_global_stockquantity_meta'] = sanitize_text_field( $input['marketplace_global_stockquantity_meta'] );
        if( isset( $input['marketplace_global_maxitemsinorder'] ) ) $new_input['marketplace_global_maxitemsinorder'] = sanitize_text_field( $input['marketplace_global_maxitemsinorder'] );
        if( isset( $input['marketplace_global_maxitemsinorder_attribute'] ) ) $new_input['marketplace_global_maxitemsinorder_attribute'] = sanitize_text_field( $input['marketplace_global_maxitemsinorder_attribute'] );
        if( isset( $input['marketplace_global_maxitemsinorder_meta'] ) ) $new_input['marketplace_global_maxitemsinorder_meta'] = sanitize_text_field( $input['marketplace_global_maxitemsinorder_meta'] );
        if( isset( $input['marketplace_global_maxitemsinorder_fixed'] ) ) $new_input['marketplace_global_maxitemsinorder_fixed'] = sanitize_text_field( $input['marketplace_global_maxitemsinorder_fixed'] );
        if( isset( $input['marketplace_global_relatedproducts'] ) ) $new_input['marketplace_global_relatedproducts'] = sanitize_text_field( $input['marketplace_global_relatedproducts'] );
        if( isset( $input['marketplace_global_relatedproducts_limit'] ) ) $new_input['marketplace_global_relatedproducts_limit'] = sanitize_text_field( $input['marketplace_global_relatedproducts_limit'] );
        return $new_input;
        
    }

    public function update_scrap_freq_option() {

        wp_clear_scheduled_hook( 'zapbott_full_exec_hook' );
        $interval = get_option('zapbott_option_scrap_freq');
        if ( $interval != 'auto' ) wp_schedule_event( strtotime( '+2 hours' ), $interval, 'zapbott_full_exec_hook' );
        
    }

    public function add_dashboard_widgets() {

        wp_add_dashboard_widget( 'zapomatic_dashboard_box', __( 'זאפומטיק', 'zapomatic' ), function () {
            $options_status = get_option( 'zapbott_option_enabled' ) == 'on' ? sprintf( '<span style="color:green;">%s</span>', __( 'פעיל', 'zapomatic' ) ) : sprintf( '<span style="color:red;">%s</span>', __( 'כבוי', 'zapomatic' ) );
            $url = esc_url( add_query_arg(
                'page',
                'zapomatic_settings',
                get_admin_url() . 'admin.php'
            ) );
            $this->init_db();
            $this->init_overview();
            $zapbott_full_exec = $this->db->is_full_exec();
            if ( $zapbott_full_exec ) {
                $active_exec = $this->db->get_active_exec();
                $active_exec_start_time = $this->overview->get_formatted_datetime( $this->db->get_row_value( $active_exec, 'start_time' ) );
                $active_exec_total = (int) $this->db->get_row_value( $active_exec, 'total' );
                $active_exec_completed = (int) $this->db->get_row_completed_products_ids( $active_exec, true );
                $active_exec_stops = (int) $this->db->get_row_value( $active_exec, 'stops' );
                $active_exec_products_data = $this->db->get_row_value( $active_exec, 'products_data' );
                $active_exec_statuses = $this->overview->map_exec_products_statuses( $active_exec_products_data, true );
                $active_exec_errors = (int) $active_exec_statuses['errors'];
                $active_exec_warnings = (int) $active_exec_statuses['warnings'];

            }
            $last_exec = $this->db->get_last_completed_exec();
            if ( $last_exec ) {
                $last_exec_error = $this->db->get_row_value( $last_exec, 'error' );
                if ( $last_exec_error ) {
                    // TODO
                }
                else {
                    $data['last_exec']['total'] = (int) $this->db->get_row_value( $last_exec, 'total' );
                    $data['last_exec']['completed'] = $this->db->get_row_completed_products_ids( $last_exec, true );
                    $data['last_exec']['stops'] = (int) $this->db->get_row_value( $last_exec, 'stops' );
                    $last_exec_products_data = $this->db->get_row_value( $last_exec, 'products_data' );
                    $data['last_exec']['statuses_count'] = $this->overview->map_exec_products_statuses( $last_exec_products_data, true );
                    $data['last_exec']['labels']['statuses'] = __( 'סטטוסים', 'zapomatic' );
                    $data['last_exec']['labels']['products'] = __( 'מוצרים', 'zapomatic' );
                    $data['last_exec']['labels']['total'] = __( 'סה"כ', 'zapomatic' );
                    $data['last_exec']['labels']['stops'] = __( 'עצירות', 'zapomatic' );
                    $data['last_exec']['labels']['completed'] = __( 'הושלמו', 'zapomatic' );
                    $data['last_exec']['labels']['warnings'] = __( 'אזהרות', 'zapomatic' );
                    $data['last_exec']['labels']['errors'] = __( 'שגיאות', 'zapomatic' );
                    $last_exec_date = $this->db->get_row_value( $last_exec, 'start_time' );
                    $last_exec_date = date( 'Y-m-d', strtotime( $last_exec_date ) );
                    $data['last_exec']['links']['statuses'] = add_query_arg(
                            array (
                                'page' => 'zapomatic',
                                'selected_date'=> $last_exec_date,
                                'status' => ''
                            ),
                            get_admin_url() . 'admin.php'
                        );
                }
            }
            $price_trends = $this->overview->get_price_trends( 7 );
            $average_positions = $this->overview->get_average_positions( 7 );
            if ( isset( $price_trends['totals'] ) && count( $price_trends['totals'] ) > 1 ) {
                $price_trends['dates_values'] = $this->overview->get_formatted_datetime( $price_trends['dates'] );
                $price_trends['dates'] = $this->overview->convert_datetime_to_days_ago( $price_trends['dates'] );
                $data['price_trends'] = $price_trends;
                $data['average_positions'] = $average_positions;
                $data['price_trends']['labels']['totals'] = __( 'מוצרים שנסרקו', 'zapomatic' );
                $data['price_trends']['labels']['ap'] = __( 'מיקום ממוצע', 'zapomatic' );
                $data['price_trends']['labels']['values'] = __( 'שווי מוצרים', 'zapomatic' );
            }
            if ( isset( $data ) ) wp_localize_script( 'zapomatic_dashboard_js', 'zapomatic_localized', $data );
            echo( '<ul class="zapomatic-dashboard-list">' );
            printf(
                '<li class="zapomatic-status zapomatic-li-33"><a href="%s"><strong>%s</strong>%s</a></li>',
                $url,
                $options_status,
                __( 'מצב רובוט', 'zapomatic' ),
            );
            $exec_freq = get_option('zapbott_option_scrap_freq');
            $exec_freq_source = array('/auto/i', '/24hour/i', '/12hour/i', '/8hour/i', '/6hour/i', '/4hour/i');
            $exec_freq_str = array(
                __( 'אוטומטי', 'zapomatic' ),
                __( 'פעם ביום', 'zapomatic' ),
                __( 'פעמיים ביום', 'zapomatic' ),
                __( '3 פעמים ביום', 'zapomatic' ),
                __( '4 פעמים ביום', 'zapomatic' ),
                __( '6 פעמים ביום', 'zapomatic' )
            );
            $assigned_url = esc_url( add_query_arg(
                array (
                    'post_status'            => 'publish',
                    'post_type'              => 'product',
                    'zapomatic_admin_filter' => 'wmodelid'
                ),
                get_admin_url() . 'edit.php'
            ) );
            printf(
                '<li class="zapomatic-assigned-models zapomatic-li-33"><a href="%s"><strong>%s</strong>%s</a></li>',
                $assigned_url,
                $this->get_assigned_models_quantity(),
                __( 'מודלים מוגדרים', 'zapomatic' ),
            );
            printf(
                '<li class="zapomatic-exec-freq zapomatic-li-33"><a href="%s"><strong>%s</strong>%s</a></li>',
                $url,
                preg_replace( $exec_freq_source, $exec_freq_str, $exec_freq ),
                __( 'תדירות סריקה', 'zapomatic' ),
            );
            global $zapomatic_validator;
            if ( $zapomatic_validator->error ) printf(
                '<li class="zapomatic-license-error zapomatic-li-100"><a href="%s"><strong style="color:red;">%s</strong>%s</a></li>',
                $url,
                $zapomatic_validator->error,
                __( 'שגיאת מנוי', 'zapomatic' )
            );
            elseif ( $this->error ) printf(
                '<li class="zapomatic-license-error zapomatic-li-100"><a href="%s"><strong style="color:red;">%s</strong>%s</a></li>',
                $url,
                $this->error,
                __( 'שגיאה', 'zapomatic' )
            );
            $status = $zapbott_full_exec ? __( 'בעבודה', 'zapomatic' ) : __( 'במנוחה', 'zapomatic' );
            printf(
                '<li class="zapomatic-exec-status zapomatic-li-40"><a><strong id="zapomatic-status">%s</strong>%s</a></li>',
                $status,
                __( 'סטטוס נוכחי', 'zapomatic' )
            );
            if ( $zapbott_full_exec ) $next_cron = __( 'לא זמין', 'zapomatic' );
            else $next_cron = $exec_freq == 'auto' ? $this->get_next_cron_time( 'zapbott_full_exec_hook', true ) : $this->get_next_cron_time( 'zapbott_full_exec_hook' );
            printf(
                '<li class="zapomatic-next-exec zapomatic-li-60"><a><strong id="zapomatic-next-exec">%s</strong>%s</a></li>',
                $next_cron ? $next_cron : __( 'ממתין לזאפ', 'zapomatic' ),
                __( 'מועד הסריקה הבאה', 'zapomatic' )
            );
            printf(
                '<li class="zapomatic-active-exec zapomatic-li-100" id="zapomatic-active-exec"
                style="display:%s;"><a><strong>%s</strong>%s<span id="zapomatic-active-exec-time">%s</span></a></li>',
                $zapbott_full_exec ? 'list-item' : 'none',
                __( 'סריקה פעילה', 'zapomatic' ),
                __( 'התחילה ב-', 'zapomatic' ),
                @$active_exec_start_time
            );
            printf(
                '<li class="zapomatic-active-exec-counter zapomatic-li-40" id="zapomatic-active-exec-counter" style="display:%s;"><a><strong><span id="zapomatic-active-exec-completed">%d</span>/<span id="zapomatic-active-exec-total">%d</span></strong>%s</a></li>',
                $zapbott_full_exec ? 'list-item' : 'none',
                @$active_exec_completed,
                @$active_exec_total,
                __( 'מוצרים שנסרקו', 'zapomatic' ),
            );
        if ( $active_exec_total ) $active_exec_pb = @round( ( @$active_exec_completed / @$active_exec_total ) * 100 );
        printf(
            '<li class="zapomatic-li-60" id="zapomatic-active-exec-pb" style="display:%s;"><a>
            <div class="zapomatic-active-exec-pb">
            <div class="zapomatic-active-exec-pb-fill" id="zapomatic-active-exec-pb-fill" style="width:%d%%;">
            <strong id="zapomatic-active-exec-pb-value">%d%%</strong>
            </div></div>
            %s</a></li>',
            $zapbott_full_exec ? 'list-item' : 'none',
            @$active_exec_pb,
            @$active_exec_pb,
            __( 'התקדמות', 'zapomatic' ),
        );
        printf(
            '<li class="zapomatic-active-exec-errors zapomatic-li-33" id="zapomatic-active-exec-errors" style="display:%s;"><a><strong id="zapomatic-active-exec-errors-value">%d</strong>%s</a></li>',
            $zapbott_full_exec ? 'list-item' : 'none',
            @$active_exec_errors,
            __( 'שגיאות', 'zapomatic' ),
        );
        printf(
            '<li class="zapomatic-active-exec-warnings zapomatic-li-33" id="zapomatic-active-exec-warnings" style="display:%s;"><a><strong id="zapomatic-active-exec-warnings-value">%d</strong>%s</a></li>',
            $zapbott_full_exec ? 'list-item' : 'none',
            @$active_exec_warnings,
            __( 'אזהרות', 'zapomatic' ),
        );
        printf(
            '<li class="zapomatic-active-exec-stops zapomatic-li-33" id="zapomatic-active-exec-stops" style="display:%s;"><a><strong id="zapomatic-active-exec-stops-value">%d</strong>%s</a></li>',
            $zapbott_full_exec ? 'list-item' : 'none',
            @$active_exec_stops,
            __( 'עצירות', 'zapomatic' ),
        );
            if ( $last_exec ) {
                if ( $last_exec_error ) {
                    print_r($last_exec_error);
                    // TODO
                }
                else {
                    $last_exec_date = $this->db->get_row_value( $last_exec, 'start_time' );
                    $last_exec_date = date( 'Y-m-d', strtotime( $last_exec_date ) );
                    printf(
                        '<li class="zapomatic-last-exec zapomatic-li-100"><a href="%s"><strong>%s</strong>%s%s</a></li>',
                        add_query_arg( array(
                            'page' => 'zapomatic',
                            'selected_date' => $last_exec_date,
                            ),
                            get_admin_url() . 'admin.php'
                        ),
                        __('סריקה אחרונה שהושלמה', 'zapomatic'),
                        __('הסתיימה ב-', 'zapomatic'),
                        $this->overview->get_formatted_datetime( $this->db->get_row_value( $last_exec, 'end_time' ) )
                    );
                    echo '<li class="zapomatic-li-100"><canvas id="zapomatic-dashboard-le-chart"></canvas></li>';
                    echo '<li class="zapomatic-li-100"><canvas id="zapomatic-dashboard-pt-chart"></canvas></li>';
                }
            }
            echo( '</ul>' );
        } );
    
    }

    public function dashboard_refresh() {

        $this->init_db();
        $this->init_overview();
        $arr = [];
        $zapbott_full_exec = $this->db->is_full_exec();
        $arr['status'] = $zapbott_full_exec ? __( 'בעבודה', 'zapomatic' ) : __( 'במנוחה', 'zapomatic' );
        $exec_freq = get_option( 'zapbott_option_scrap_freq' );
        $next_exec = $exec_freq == 'auto' ? $this->get_next_cron_time( 'zapbott_full_exec_hook', true ) : $this->get_next_cron_time( 'zapbott_full_exec_hook' );
        if ( $zapbott_full_exec ) $arr['next_exec'] = __( 'לא זמין', 'zapomatic' );
        elseif ( $next_exec ) $arr['next_exec'] = $next_exec;
        else $arr['next_exec'] = __( 'ממתין לזאפ', 'zapomatic' );
        $active_exec = $this->db->get_active_exec();
        if ( $active_exec ) {
            $arr['active_exec']['start_time'] = $this->overview->get_formatted_datetime( $this->db->get_row_value( $active_exec, 'start_time' ) );
            $arr['active_exec']['total'] = (int) $this->db->get_row_value( $active_exec, 'total' );
            $arr['active_exec']['completed'] = (int) $this->db->get_row_completed_products_ids( $active_exec, true );
            $arr['active_exec']['stops'] = (int) $this->db->get_row_value( $active_exec, 'stops' );
            $active_exec_products_data = $this->db->get_row_value( $active_exec, 'products_data' );
            if ( $active_exec_products_data ) {
                $active_exec_statuses = $this->overview->map_exec_products_statuses( $active_exec_products_data, true );
                $arr['active_exec']['errors'] = (int) $active_exec_statuses['errors'];
                $arr['active_exec']['warnings'] = (int) $active_exec_statuses['warnings'];
            }
        }
        echo json_encode( $arr );
        die();

    }

    protected function get_next_cron_time( $cron_name, $dashboard = false ) {

        foreach ( _get_cron_array() as $timestamp => $crons ) {
            if( in_array( $cron_name, array_keys( $crons ) ) ){
                if ( ceil( ( $timestamp - time() ) / 60 ) <= 0 ) { return sprintf( '%s', __( 'צפויה להתחיל כל רגע', 'zapomatic' ) ); }
                else {
                    if ( $dashboard == true ) {
                        if ( ($timestamp - time() ) <= 120 ) return sprintf(
                            '%s%s %s',
                            __('בעוד כ-', 'zapomatic'),
                            ceil( ($timestamp - time()) / 60 ),
                            __('דקות', 'zapomatic')
                        ); 
                        else return __( 'צפויה להתחיל בקרוב...', 'zapomatic' );
                    }
                    else return sprintf(
                        '%s%s %s',
                        __( 'בעוד כ-', 'zapomatic' ),
                        ceil( ( $timestamp - time() ) / 60 ),
                        __( 'דקות', 'zapomatic' )
                    ); 
                } 
            }
        }
        return false;
    
    }

    public function admin_columns( $columns ) {

        $columns['zapbott_lastscan'] = __('סריקה אחרונה', 'zapomatic');
        $columns['zapbott_pricedif'] = __('שינוי', 'zapomatic');
        $columns['zapbott_modelurl'] = __('עמוד מוצר בזאפ', 'zapomatic');
        return $columns;
    }

    public function admin_columns_data( $column, $post_id ) {

        switch ( $column ) {
            case 'zapbott_lastscan':
                printf(
                    '<span>%s</span>',
                    @get_post_meta( $post_id, '_zapbott_pd_log_lastscan', true)
                );
                break;
            case 'zapbott_pricedif':
                $column_lastprice = get_post_meta( $post_id, '_zapbott_pd_log_lastprice', true);
                $column_newprice = get_post_meta( $post_id, '_zapbott_pd_log_newprice', true);
                if ( !empty($column_newprice) ) {
                    if ( $column_newprice > $column_lastprice ) {
                        $column_pricedif_color = 'green';
                        $column_pricedif = $column_newprice - $column_lastprice;
                    }
                    elseif ( $column_newprice < $column_lastprice ) {
                        $column_pricedif_color = 'red';
                        $column_pricedif = $column_lastprice - $column_newprice;
                    }
                    else {
                        $column_pricedif_color = 'inherit';
                        $column_pricedif = '0';
                    }
                    echo '<span style="color:'.$column_pricedif_color.';">₪'.$column_pricedif.'</span>';
                }
                break;
            case 'zapbott_modelurl':
                $column_modelurl = @get_post_meta( $post_id, '_zapbott_pd_zap_modelurl', true);
                if ( !$column_modelurl ) break;
                $current_product_price = (int) get_post_meta( $post_id, '_price', true);
                $column_firstprice = (int) get_post_meta( $post_id, '_zapbott_pd_log_firstprice', true);
                $column_firstprice_color = $column_firstprice >= $current_product_price ? 'green' : 'red';
                $column_firstprice_value = $column_firstprice >= $current_product_price ? $current_product_price : $column_firstprice;
                
                $column_toptable = get_post_meta( $post_id, '_zapbott_pd_log_toptable', true );
                printf(
                    '<a href="%s" class="%s" target="zapbott">%s<img style="margin:0;" src="%s" /><span style="display:table-caption;color:%s;">₪%s</span></a>',
                    esc_attr( $column_modelurl ),
                    !empty( $column_toptable ) ? 'zapomatic-toptable' : '',
                    !empty( $column_toptable ) ? $this->get_edit_products_toptable( $column_toptable, $current_product_price ) : '',
                    esc_attr( plugin_dir_url( __FILE__ ) . 'images/zapicon.png' ),
                    $column_firstprice_color,
                    esc_attr( $column_firstprice_value ),
                );
                break;
        }

    }

    public function admin_filter() {

        global $post_type;
        if ( $post_type == 'product' ) {
             $selected = isset( $_GET['zapomatic_admin_filter'] ) ? sanitize_text_field( $_GET['zapomatic_admin_filter'] ) : NULL;
            ?>
            <select name="zapomatic_admin_filter" id="zapomatic_admin_filter" >
            <option value><?php echo __('סינון לפי זאפומטיק', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'wmodelid' ) { echo 'selected'; } ?> value="wmodelid"><?php _e('בעלי קישור לרובוט', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'nmodelid' ) { echo 'selected'; } ?> value="nmodelid"><?php _e('ללא קישור לרובוט', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'isfirst' ) { echo 'selected'; } ?> value="isfirst"><?php _e('הזול ביותר בזאפ', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'isntfirst' ) { echo 'selected'; } ?> value="isntfirst"><?php _e('לא הזול ביותר בזאפ', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'isminimum' ) { echo 'selected'; } ?> value="isminimum"><?php _e('הגיעו למחיר מינימום', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'isntminimum' ) { echo 'selected'; } ?> value="isntminimum"><?php _e('לא הגיעו למחיר מינימום', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'isntminisntfirst' ) { echo 'selected'; } ?> value="isntminisntfirst"><?php _e('לא הזול ביותר בזאפ + לא הגיעו למחיר מינימום', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'tempdis' ) { echo 'selected'; } ?> value="tempdis"><?php _e('רובוט בשהייה', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'errors' ) { echo 'selected'; } ?> value="errors"><?php _e('שגיאות סריקה ברובוט', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'disabled' ) { echo 'selected'; } ?> value="disabled"><?php _e('לא פעילים ברובוט', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'eilat' ) { echo 'selected'; } ?> value="eilat"><?php _e('מכירה באילת בלבד', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'enmirror' ) { echo 'selected'; } ?> value="enmirror"><?php _e('מוצגים באתר המראה', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'dismirror' ) { echo 'selected'; } ?> value="dismirror"><?php _e('מוסתרים באתר המראה', 'zapomatic'); ?></option>
            <option <?php if ( $selected == 'marketplace' ) { echo 'selected'; } ?> value="marketplace"><?php _e('מוצגים במרקטפלייס', 'zapomatic'); ?></option>
            </select>
            <?php
        }

    }

    public function admin_filter_results( $query ) {

        global $post_type;
            $filter = !empty( $_GET['zapomatic_admin_filter'] ) ? sanitize_text_field( $_GET['zapomatic_admin_filter'] ) : NULL;
            if( !empty( $filter ) && $post_type == 'product' ){
                if ($filter == 'wmodelid') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_zap_modelurl',
                            'value'   => '',
                            'compare' => '!=',
                        )
                    );
                }
                elseif ($filter == 'nmodelid') {
                    $meta_key_query = array(
                        'relation' => 'OR',
                        array(
                            'key'     => '_zapbott_pd_zap_modelurl',
                            'compare' => 'NOT EXISTS',
                        ),
                        array(
                            'key'     => '_zapbott_pd_zap_modelurl',
                            'value'   => '',
                            'compare' => '=',
                        ),
                    );
                }
                elseif ($filter == 'isfirst') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_log_isbestprice',
                            'value'   => 'true',
                            'compare' => '=',
                        )
                    );
                }
                elseif ($filter == 'isntfirst') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_log_isbestprice',
                            'value'   => 'false',
                            'compare' => '=',
                        )
                    );
                }
                elseif ($filter == 'isntminisntfirst') {
                    $meta_key_query = array(
                        'relation' => 'AND',
                        array(
                            'key'     => '_zapbott_pd_log_isbestprice',
                            'value'   => 'false',
                            'compare' => '=',
                        ),
                        array(
                            'key'     => '_zapbott_pd_log_isminprice',
                            'value'   => 'false',
                            'compare' => '=',
                        ),
                    );
                }
                elseif ($filter == 'isntminimum') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_log_isminprice',
                            'value'   => 'false',
                            'compare' => '=',
                        )
                    );
                }
                elseif ($filter == 'isminimum') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_log_isminprice',
                            'value'   => 'true',
                            'compare' => '=',
                        )
                    );
                }
                elseif ($filter == 'tempdis') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_tempdis',
                            'value'   => strtotime('today'),
                            'compare' => '>',
                        )
                    );
                }
                elseif ($filter == 'errors') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_log_status',
                            'compare' => 'LIKE',
                            'value'   => __('שגיאה', 'zapomatic'),
                        )
                    );
                }
                elseif ($filter == 'disabled') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_robot_enabled',
                            'compare' => '=',
                            'value'   => 'no',
                        )
                    );
                }
                elseif ($filter == 'enmirror') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapmirror_disable',
                            'compare' => '!=',
                            'value'   => 'yes',
                        )
                    );
                }
                elseif ($filter == 'dismirror') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapmirror_disable',
                            'compare' => '=',
                            'value'   => 'yes',
                        )
                    );
                }
                elseif ($filter == 'marketplace') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapmarket_enable',
                            'compare' => '=',
                            'value'   => 'yes',
                        )
                    );
                }
                elseif ($filter == 'eilat') {
                    $meta_key_query = array(
                        array(
                            'key'     => '_zapbott_pd_zap_eilat',
                            'compare' => '=',
                            'value'   => 'yes',
                        )
                    );
                }
                $query->set( 'meta_query', $meta_key_query );
            }

    }

    public function edit_products_bulk_actions( $bulk_actions ) {

        $bulk_actions[ 'zapomatic_hide_mirror' ] = __('הסתר באתר המראה', 'zapomatic');
        $bulk_actions[ 'zapomatic_show_mirror' ] = __('הצג באתר המראה', 'zapomatic');
        $bulk_actions[ 'zapomatic_hide_marketplace' ] = __('הסתר במרקטפלייס', 'zapomatic');
        $bulk_actions[ 'zapomatic_show_marketplace' ] = __('הצג במרקטפלייס', 'zapomatic');
        return $bulk_actions;
    
    }

    public function edit_products_bulk_actions_handle( $redirect, $doaction, $object_ids ) {

        if( $doaction === 'zapomatic_hide_mirror' ) {
            foreach ( $object_ids as $product_id ) update_post_meta( $product_id, '_zapmirror_disable', 'yes' );
            $redirect = add_query_arg(
                array(
                    'bulk_action' => 'zapomatic_marked_hide_mirror',
                    'changed' => count( $object_ids ),
                ),
                $redirect
            );
        }
        if( $doaction === 'zapomatic_show_mirror' ) {
            foreach ( $object_ids as $product_id ) update_post_meta( $product_id, '_zapmirror_disable', '' );
            $redirect = add_query_arg(
                array(
                    'bulk_action' => 'zapomatic_marked_show_mirror',
                    'changed' => count( $object_ids ),
                ),
                $redirect
            );
        }
        if( $doaction === 'zapomatic_hide_marketplace' ) {
            foreach ( $object_ids as $product_id ) update_post_meta( $product_id, '_zapmarket_enable', '' );
            $redirect = add_query_arg(
                array(
                    'bulk_action' => 'zapomatic_marked_hide_marketplace',
                    'changed' => count( $object_ids ),
                ),
                $redirect
            );
        }
        if( $doaction === 'zapomatic_show_marketplace' ) {
            foreach ( $object_ids as $product_id ) update_post_meta( $product_id, '_zapmarket_enable', 'yes' );
            $redirect = add_query_arg(
                array(
                    'bulk_action' => 'zapomatic_marked_show_marketplace',
                    'changed' => count( $object_ids ),
                ),
                $redirect
            );
        }
        return $redirect;
    
    }

    public function edit_products_bulk_actions_notices() {

        if ( isset( $_REQUEST[ 'bulk_action' ] ) && isset( $_REQUEST[ 'changed' ] ) && $_REQUEST[ 'changed' ] ) {
            if ( $_REQUEST[ 'bulk_action' ] == 'zapomatic_marked_hide_mirror' ) $msg = _n( 'מוצר %d הוסתר באתר המראה.', '%d מוצרים הוסתרו באתר המראה.', $_REQUEST[ 'changed' ] );
            elseif ( $_REQUEST[ 'bulk_action' ] == 'zapomatic_marked_show_mirror' ) $msg = _n( 'מוצר %d הופעל באתר המראה.', '%d מוצרים הופעלו באתר המראה.', $_REQUEST[ 'changed' ] );
            elseif ( $_REQUEST[ 'bulk_action' ] == 'zapomatic_marked_hide_marketplace' ) $msg = _n( 'מוצר %d הוסתר במרקטפלייס.', '%d מוצרים הוסתרו במרקטפלייס.', $_REQUEST[ 'changed' ] );
            elseif ( $_REQUEST[ 'bulk_action' ] == 'zapomatic_marked_show_marketplace' ) $msg = _n( 'מוצר %d הופעל במרקטפלייס.', '%d מוצרים הופעלו במרקטפלייס.', $_REQUEST[ 'changed' ] );
            else return;
            printf(
                '<div id="message" class="updated notice is-dismissible"><p>' . $msg . '</p></div>',
                $_REQUEST[ 'changed' ]
            );
        }

    }

    public function add_bulk_edit_fields() {
        ?>
        <h5><?php _e( 'הגדרות רובוט מחירים', 'zapomatic' ); ?></h5>
        <label class="alignleft">
            <span class="title"><?php _e( 'הפעל רובוט', 'zapomatic' ); ?></span>
            <select name="_zapbott_pd_robot_enabled" class="zapbott_pd_robot_enabled change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="default"><?php _e( 'ברירת מחדל', 'zapomatic' ); ?></option>
                    <option value="no"><?php _e( 'לא', 'zapomatic' ); ?></option>
            </select>
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('מכירה באילת בלבד', 'zapomatic'); ?></span>
            <select name="_zapbott_pd_zap_eilat" class="zapbott_pd_zap_eilat change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="yes"><?php _e( 'כן', 'zapomatic' ); ?></option>
                    <option value="no"><?php _e( 'לא', 'zapomatic' ); ?></option>
            </select>
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('קנייה חכמה בלבד', 'zapomatic'); ?></span>
            <select name="_zapbott_pd_zap_smartonly" class="zapbott_pd_zap_smartonly change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="default"><?php _e( 'ברירת מחדל', 'zapomatic' ); ?></option>
                    <option value="yes"><?php _e( 'פעיל', 'zapomatic' ); ?></option>
                    <option value="no"><?php _e( 'כבוי', 'zapomatic' ); ?></option>
            </select>
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('לפי מקום', 'zapomatic'); ?></span>
                <input type="number" name="_zapbott_pd_zap_required_position" class="text zapbott_pd_zap_required_position" min="1" placeholder="<?php _e( '— ללא שינוי —', 'zapomatic' ); ?>" value="">
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('פעולה', 'zapomatic'); ?></span>
            <select name="_zapbott_pd_zap_operation" class="zapbott_pd_zap_operation change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="dec"><?php _e( 'הורדת מחיר', 'zapomatic' ); ?></option>
                    <option value="inc"><?php _e( 'העלאת מחיר', 'zapomatic' ); ?></option>
            </select>
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('בכמה?', 'zapomatic'); ?></span>
                <input type="number" name="_zapbott_pd_zap_price_drop" class="text zapbott_pd_zap_price_drop" min="0" placeholder="<?php _e( '— ללא שינוי —', 'zapomatic' ); ?>" value="">
        </label>
        <div class="inline-edit-group">
        <label class="alignleft">
            <span class="title"><?php _e('מחיר מינימום', 'zapomatic'); ?></span>
            <span class="input-text-wrap">
                <select name="change_zapbott_min_price" class="change_zapbott_min_price change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="1"><?php _e( 'שנה ל:', 'zapomatic' ); ?></option>
                    <option value="2"><?php _e( 'הגדל מחיר קיים ב (סכום קבוע או %):', 'zapomatic' ); ?></option>
                    <option value="3"><?php _e( 'יש להקטין את המחיר הקיים ב (מספר קבוע או %):', 'zapomatic' ); ?></option>
                </select>
                <input type="text" name="_zapbott_pd_zap_min_price" class="text zapbott_pd_zap_min_price" min="1" placeholder="<?php _e( 'הזן מחיר (₪)', 'zapomatic' ); ?>" value="">
            </span>
        </label>
        </div>

        <div class="inline-edit-group">
        <label class="alignleft">
            <span class="title"><?php _e('מחיר מקסימום', 'zapomatic'); ?></span>
            <span class="input-text-wrap">
                <select name="change_zapbott_max_price" class="change_zapbott_max_price change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="1"><?php _e( 'שנה ל:', 'zapomatic' ); ?></option>
                    <option value="2"><?php _e( 'הגדל מחיר קיים ב (סכום קבוע או %):', 'zapomatic' ); ?></option>
                    <option value="3"><?php _e( 'יש להקטין את המחיר הקיים ב (מספר קבוע או %):', 'zapomatic' ); ?></option>
                </select>
                <input type="text" name="_zapbott_pd_zap_max_price" class="text zapbott_pd_zap_max_price" min="1" placeholder="<?php _e( 'הזן מחיר (₪)', 'zapomatic' ); ?>" value="">
            </span>
        </label>
        </div>

        <div class="inline-edit-group">
        <label class="alignleft">
            <span class="title"><?php _e( 'מחיר ברירת מחדל', 'zapomatic' ); ?></span>
            <span class="input-text-wrap">
                <select name="change_zapbott_default_price" class="change_zapbott_default_price change_to">
                    <option value=""><?php _e( '— ללא שינוי —', 'zapomatic' ); ?></option>
                    <option value="1"><?php _e( 'שנה ל:', 'zapomatic' ); ?></option>
                    <option value="2"><?php _e( 'הגדל מחיר קיים ב (סכום קבוע או %):', 'zapomatic' ); ?></option>
                    <option value="3"><?php _e( 'יש להקטין את המחיר הקיים ב (מספר קבוע או %):', 'zapomatic' ); ?></option>
                </select>
                <input type="text" name="_zapbott_pd_zap_default_price" class="text zapbott_pd_zap_default_price" min="1" placeholder="<?php _e( 'הזן מחיר (₪)', 'zapomatic' ); ?>" value="">
            </span>
        </label>
        </div>
        <label class="alignleft">
            <span class="title"><?php _e('עקוב אחרי חנות', 'zapomatic'); ?></span>
                <input type="text" name="_zapbott_pd_zap_follow" class="text zapbott_pd_zap_follow"  placeholder="<?php _e( '— ללא שינוי —', 'zapomatic' ); ?>" value="">
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('התעלם מחנויות', 'zapomatic'); ?></span>
                <input type="text" name="_zapbott_pd_zap_excludes" class="text zapbott_pd_zap_excludes"  placeholder="<?php _e( '— ללא שינוי —', 'zapomatic' ); ?>" value="">
        </label>
        <label class="alignleft">
            <span class="title"><?php _e('השהיית סריקות עד לתאריך', 'zapomatic'); ?></span>
            <input type="date" class="zapbott_pd_tempdis" name="_zapbott_pd_tempdis" value="" placeholder="">
        </label>
        
        <?php
    }

    public function edit_product_data_fields_update( $post_id ) {

        update_post_meta( $post_id, '_zapbott_pd_robot_enabled', sanitize_text_field( $_POST['_zapbott_pd_robot_enabled'] ) );
        if ( !filter_var( $_POST['_zapbott_pd_zap_modelurl'], FILTER_VALIDATE_URL ) ) $modelurl_final = null;
        else {
            $modelurl_input = $_POST['_zapbott_pd_zap_modelurl'];
            $modelurl_components = parse_url( $modelurl_input );
            parse_str( $modelurl_components['query'], $modelurl_params );
            $modelurl_base = strtok( $modelurl_input, '?' );
            $modelurl_final = sprintf( '%s?modelid=%s', $modelurl_base, $modelurl_params['modelid'] );
        }
        update_post_meta( $post_id, '_zapbott_pd_zap_modelurl', esc_url( $modelurl_final ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_required_position', sanitize_text_field( $_POST['_zapbott_pd_zap_required_position'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_price_drop', sanitize_text_field( $_POST['_zapbott_pd_zap_price_drop'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_operation', sanitize_text_field( $_POST['_zapbott_pd_zap_operation'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_min_price', sanitize_text_field( $_POST['_zapbott_pd_zap_min_price'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_default_price', sanitize_text_field( $_POST['_zapbott_pd_zap_default_price'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_max_price', sanitize_text_field( $_POST['_zapbott_pd_zap_max_price'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_follow', sanitize_text_field( $_POST['_zapbott_pd_zap_follow'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_nozapbuy', sanitize_text_field( $_POST['_zapbott_pd_zap_nozapbuy'] ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_excludes', sanitize_text_field( $_POST['_zapbott_pd_zap_excludes'] ) );
        update_post_meta( $post_id, '_zapbott_pd_tempdis', strtotime( sanitize_text_field( $_POST['_zapbott_pd_tempdis'] ) ) );
        update_post_meta( $post_id, '_zapbott_pd_zap_smartonly', sanitize_text_field( $_POST['_zapbott_pd_zap_smartonly'] ) );
        $zapbott_pd_zap_eilat = isset($_POST['_zapbott_pd_zap_eilat']) ? 'yes' : ''; 
        update_post_meta( $post_id, '_zapbott_pd_zap_eilat', $zapbott_pd_zap_eilat );
        return;

    }

    public function update_bulk_edit_fields( $product ) {

        $changes = false;
        if ( !empty( $_REQUEST['_zapbott_pd_robot_enabled'] ) ) {
            $product->update_meta_data( '_zapbott_pd_robot_enabled', $_REQUEST['_zapbott_pd_robot_enabled'] === 'no' ? 'no' : 'default' );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_eilat'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_eilat', $_REQUEST['_zapbott_pd_zap_eilat'] === 'yes' ? 'yes' : '' );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_required_position'] ) ) {
            $change_value = $_REQUEST['_zapbott_pd_zap_required_position'];
            if ( $change_value === 0 ) $change_value = '';
            $product->update_meta_data( '_zapbott_pd_zap_required_position', sanitize_text_field( $change_value ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_smartonly'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_smartonly', sanitize_text_field( $_REQUEST['_zapbott_pd_zap_smartonly'] ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_operation'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_operation', sanitize_text_field( $_REQUEST['_zapbott_pd_zap_operation'] ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_price_drop'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_price_drop', sanitize_text_field( $_REQUEST['_zapbott_pd_zap_price_drop'] ) );
            $changes = true;
        }
        if ( !empty($_REQUEST['change_zapbott_min_price'] ) && isset($_REQUEST['_zapbott_pd_zap_min_price'])) {
            $current_value = @$product->get_meta( '_zapbott_pd_zap_min_price' );
            $change_type = $_REQUEST['change_zapbott_min_price'];
            $change_value = $this->get_bulk_edit_price_result( $change_type, floatval( $_REQUEST['_zapbott_pd_zap_min_price'] ), $current_value );
            if ( $change_value !== 0 ) {
                $product->update_meta_data( '_zapbott_pd_zap_min_price', sanitize_text_field( $change_value ) );
                $changes = true;
            }
        }
        if ( !empty($_REQUEST['change_zapbott_max_price'] ) && isset($_REQUEST['_zapbott_pd_zap_max_price'])) {
            $current_value = @$product->get_meta( '_zapbott_pd_zap_max_price' );
            $change_type = $_REQUEST['change_zapbott_max_price'];
            $change_value = $this->get_bulk_edit_price_result( $change_type, floatval( $_REQUEST['_zapbott_pd_zap_max_price'] ), $current_value );
            if ( $change_value === 0 ) $change_value = '';
            $product->update_meta_data( '_zapbott_pd_zap_max_price', sanitize_text_field( $change_value ) );
            $changes = true;
            
        }
        if ( !empty($_REQUEST['change_zapbott_default_price'] ) && isset($_REQUEST['_zapbott_pd_zap_default_price'])) {
            $current_value = @$product->get_meta( '_zapbott_pd_zap_default_price' );
            $change_type = $_REQUEST['change_zapbott_default_price'];
            $change_value = $this->get_bulk_edit_price_result( $change_type, floatval( $_REQUEST['_zapbott_pd_zap_default_price'] ), $current_value );
            if ( $change_value === 0 ) $change_value = '';
            $product->update_meta_data( '_zapbott_pd_zap_default_price', sanitize_text_field( $change_value ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_follow'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_follow', sanitize_text_field( $_REQUEST['_zapbott_pd_zap_follow'] ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_zap_excludes'] ) ) {
            $product->update_meta_data( '_zapbott_pd_zap_excludes', sanitize_text_field( $_REQUEST['_zapbott_pd_zap_excludes'] ) );
            $changes = true;
        }
        if ( !empty( $_REQUEST['_zapbott_pd_tempdis'] ) ) {
            $product->update_meta_data( '_zapbott_pd_tempdis', strtotime( sanitize_text_field( $_REQUEST['_zapbott_pd_tempdis'] ) ) );
            $changes = true;
        }
        
        if ( $changes === true ) $product->save();

    }

    public function test_connection() {

        $ch = curl_init();
        $url = "https://www.zap.co.il/";
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            echo json_encode( curl_error( $ch ) );
        } else {
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $headers = substr($response, 0, $header_size);
            echo json_encode( $headers );
        }
        curl_close($ch);
        exit;

    }

    public function plugin_activation() {

        $interval = get_option('zapbott_option_scrap_freq');
        if ( !empty( $interval ) && $interval != 'auto' ) wp_schedule_event( strtotime( '+2 hours' ), $interval, 'zapbott_full_exec_hook' );
        return;

    }

    public function plugin_deactivation() {

        update_option( 'zapbott_full_exec_heartbeat', '', true );
        wp_clear_scheduled_hook( 'zapbott_full_exec_hook' );
        require_once( 'includes/class-updater.php' );
        remove_action( 'zapbott_full_exec_hook', array( 'Zapomatic_Updater', 'full_exec' ) );
        remove_filter( 'cron_schedules', array( 'Zapomatic_Updater', 'cron_intervals' ) );
        require_once( 'includes/class-engine.php' );

    }

    public function edit_product_data_tab( $product_data_tabs ) {

        $product_data_tabs['zapbott-tab'] = array(
            'label' => __( 'הגדרות רובוט מחירים', 'zapomatic' ),
            'target' => 'zapbott_product_data',
            'priority' => 97,
            'class' => ''
        );
        return $product_data_tabs;

    }
    
    public function edit_product_data_fields() {
        
        global $woocommerce, $post, $post_id;
        $_zapbott_pd_zap_modelurl = get_post_meta( $post_id, '_zapbott_pd_zap_modelurl', true);
        ?>
        <div id="zapbott_product_data" class="panel woocommerce_options_panel">
            <div class="options_group"><p class="form-field"><strong><?php _e( 'הגדרות רובוט למוצר', 'zapomatic' ); ?></strong></p>
                <?php
                woocommerce_wp_select( array(
                        'id'      => '_zapbott_pd_robot_enabled', 
                        'wrapper_class' => 'show_if_simple show_if_variable',
                        'label'   => __( 'הפעל רובוט עבור מוצר זה', 'zapomatic' ),
                        'options' => array(
                            'default'   => __( 'ברירת מחדל', 'zapomatic' ),
                            'no' => __( 'לא', 'zapomatic' )
                        ),
                        'style' => 'width:125px;'
                        )
                    );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_zap_modelurl', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'קישור לעמוד המוצר בזאפ *', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( 'לדוגמה: https://www.zap.co.il/model.aspx?modelid=1075935. ללא קישור הרובוט לא יפעל!', 'zapomatic' ),
                    ) );
                if ( !empty($_zapbott_pd_zap_modelurl) ) {
                    echo '
                    <p class="form-field _zapbott_pd_zap_modelurl_open show_if_simple show_if_variable" style="">
                    <label for="_zapbott_pd_zap_modelurl_open">פתיחת עמוד מודל בזאפ</label>
                        <a href="' . $_zapbott_pd_zap_modelurl . '" target="zapbott">
                            <img style="margin:0;" src="' . plugin_dir_url( __FILE__ ) . 'images/zapicon.png">
                        </a>
                    </p>
                    '; }
                woocommerce_wp_checkbox( array(
                    'id'            => '_zapbott_pd_zap_eilat', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'מכירה באילת בלבד', 'zapomatic' ),
                    ) );
                woocommerce_wp_select( array(
                    'id'      => '_zapbott_pd_zap_smartonly', 
                    'wrapper_class' => 'show_if_simple show_if_variable',
                    'label'   => __( 'קנייה חכמה בלבד', 'zapomatic' ),
                    'desc_tip'      => true,
                    'description'   => __( 'התעלם מכל החנויות <b>שאינן</b> בעלות תו "קנייה חכמה" בזאפ.<br />במידה ואין חנויות בעלות התו - מצב "קנייה חכמה" יבוטל אוטומטית', 'zapomatic' ),
                    'options' => array(
                        'default'   => __( 'ברירת מחדל', 'zapomatic' ),
                        'yes' => __( 'פעיל', 'zapomatic' ),
                        'no' => __( 'כבוי', 'zapomatic' )
                        
                    ),
                    'style' => 'width:125px;'
                    )
                );
                echo '<br />';
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_required_position', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'קבע מחיר לפי מקום:', 'zapomatic' ), 
                    'desc_tip'      => false,
                    'type'          => 'number', 
                    'placeholder' => '1',
                    'custom_attributes' => array(
                        'step' 	=> 'any',
                        'min'	=> '1'
                    ),
                    'style' => 'width:55px;'
                ) );
                woocommerce_wp_select( array( 
                    'id'      => '_zapbott_pd_zap_operation', 
                    'wrapper_class' => 'show_if_simple show_if_variable',
                    'label'   => __( 'פעולה', 'zapomatic' ),
                    'options' => array(
                        'dec'   => __( 'הורדת מחיר', 'zapomatic' ),
                        'inc' => __( 'העלאת מחיר', 'zapomatic' )
                    ),
                    'style' => 'width:125px;'
                    )
                );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_price_drop', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'בכמה? (₪):', 'zapomatic' ), 
                    'desc_tip'      => false,
                    'type'          => 'number', 
                    'placeholder'   => '0', 
                    'custom_attributes' => array(
                        'step' 	=> 'any',
                        'min'	=> '0'
                    ),
                    'style' => 'width:55px;'
                ) );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_min_price', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'מחיר מינימום (₪) *:', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( 'הקו האדום. מתחת למחיר זה הרובוט לא ירד לעולם.', 'zapomatic' ),
                    'type'          => 'number', 
                    'custom_attributes' => array(
                        'step' 	=> 'any',
                        'min'	=> '1'
                    ),
                    'style' => 'width:100px;'
                ) );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_max_price', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'מחיר מקסימום (₪):', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( 'מחיר מקסימלי למוצר, עד שמתחרה יוריד את המחיר.', 'zapomatic' ),
                    'type'          => 'number', 
                    'custom_attributes' => array(
                        'step' 	=> 'any',
                        'min'	=> '1'
                    ),
                    'style' => 'width:100px;'
                ) );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_default_price', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'מחיר ברירת מחדל (₪):', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( '"מחיר התחלתי/מחיר רצוי". יעודכן במידה והחנות שלך תהיה בודדה בעמוד המוצר', 'zapomatic' ),
                    'type'          => 'number', 
                    'custom_attributes' => array(
                        'step' 	=> 'any',
                        'min'	=> '1'
                    ),
                    'style' => 'width:100px;'
                ) );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_follow', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'עקוב אחרי חנות:', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( 'יש להזין את מזהה החנות (siteid) בלבד.<br />במידה והחנות לא קיימת בעמוד, המחיר יקבע לפי ההגדרות הרגילות.', 'zapomatic' ),
                    'style' => 'width:100px;'
                ) );
                echo '<br />';
                woocommerce_wp_select( array(
                    'id'      => '_zapbott_pd_zap_nozapbuy', 
                    'wrapper_class' => 'show_if_simple show_if_variable',
                    'label'   => __( 'התעלם מקנייה דרך זאפ', 'zapomatic' ),
                    'desc_tip'      => true,
                    'description'   => __( 'התעלם מכל החנויות שמוכרות מוצרים <b>דרך זאפ</b>.<br />במידה וחנות מוכרת מוצר גם דרך זאפ וגם דרך החנות - רק החנות תוצג ותילקח בחשבון.', 'zapomatic' ),
                    'options' => array(
                        'default'   => __( 'ברירת מחדל', 'zapomatic' ),
                        'yes' => __( 'פעיל', 'zapomatic' ),
                        'no' => __( 'כבוי', 'zapomatic' )
                        
                    ),
                    'style' => 'width:125px;'
                    )
                );
                woocommerce_wp_text_input( array(
                    'id'            => '_zapbott_pd_zap_excludes', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'התעלם מחנויות:', 'zapomatic' ), 
                    'desc_tip'      => true,
                    'description'   => __( 'יש להזין את מזהי החנויות (siteid) מופרדים ברווח.<br />לדוגמה: 5832 48592 58219', 'zapomatic' ), 
                    'style' => 'width:150px;'
                ) );
                echo '<br />';
                $_zapbott_pd_tempdis_value = @get_post_meta( $post_id, '_zapbott_pd_tempdis', true);
                $_zapbott_pd_tempdis = !empty( $_zapbott_pd_tempdis_value ) && $_zapbott_pd_tempdis_value > time() ? date( "Y-m-d", (int) $_zapbott_pd_tempdis_value ) : NULL;
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_tempdis', 
                    'wrapper_class' => 'show_if_simple show_if_variable', 
                    'label'         => __( 'השהיית סריקות עד לתאריך', 'zapomatic' ), 
                    'type'          => 'date',
                    'value'         => $_zapbott_pd_tempdis,
                    'style'         => 'width:165px;'
                ) );
                ?>
            </div>
            <div class="options_group"><p class="form-field"><strong><?php echo __('לוג אחרון', 'zapomatic'); ?></strong></p>
                <?php
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_lastscan', 
                    'label'         => __( 'תאריך סריקה אחרון:', 'zapomatic' ),
                    'custom_attributes' => array('readonly' => 'readonly'),
                    'style' => 'width:150px;'
                ) );
                $_zapbott_pd_log_status = @get_post_meta( $post_id, '_zapbott_pd_log_status', true );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_status_scan_model',
                    'value'         => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['scan_model'] )['info'],
                    'label'         => __( 'סטטוס סריקה:', 'zapomatic' ),
                    'style'         => sprintf( 'border-color:%s;', Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['scan_model'] )['color'] ),
                    'custom_attributes' => array(
                        'readonly' => 'readonly',
                        'title' => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['scan_model'] )['info']
                        )
                ) );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_status_calc_model',
                    'value'         => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['calc_model'] )['info'],
                    'label'         => __( 'שיטת חישוב:', 'zapomatic' ),
                    'style'         => sprintf( 'border-color:%s;', Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['calc_model'] )['color'] ),
                    'custom_attributes' => array(
                        'readonly' => 'readonly',
                        'title' => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['calc_model'] )['info']
                        )
                ) );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_status_update_product',
                    'value'         => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['update_product'], $_zapbott_pd_log_status )['info'],
                    'label'         => __( 'עדכון מחיר:', 'zapomatic' ),
                    'style'         => sprintf( 'border-color:%s;', Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['update_product'], $_zapbott_pd_log_status )['color'] ),
                    'custom_attributes' => array(
                        'readonly' => 'readonly',
                        'title' => Zapomatic_Updater::status_decode( $_zapbott_pd_log_status['update_product'], $_zapbott_pd_log_status )['info']
                        )
                ) );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_lastprice', 
                    'label'         => __( 'מחיר קודם:', 'zapomatic' ), 
                    'custom_attributes' => array('readonly' => 'readonly'),
                    'desc_tip'      => true,
                    'description'   => __( 'כולל מע"מ. לא כולל עלות משלוח (במידה והוגדרה)', 'zapomatic' ), 
                    'style' => 'width:100px'
                ) );
                woocommerce_wp_text_input( array( 
                    'id'            => '_zapbott_pd_log_newprice', 
                    'label'         => __( 'מחיר חדש:', 'zapomatic' ), 
                    'custom_attributes' => array('readonly' => 'readonly'),
                    'desc_tip'      => true,
                    'description'   => __( 'כולל מע"מ. לא כולל עלות משלוח (במידה והוגדרה)', 'zapomatic' ), 
                    'style' => 'width:100px'
                ) );
                $this->init_overview();
                $_zapbott_pd_log_toptable = $this->overview->get_included_toptable( $post_id );
                if ( $_zapbott_pd_log_toptable != null ) {
                ?>
                <p class="form-field _zapbott_pd_log_table ">
                <label for="_zapbott_pd_log_table"><?php echo __('טבלת מתחרים', 'zapomatic'); ?>:</label>
                <table class="widefat fixed" id="zapomatic-toptable" name="_zapbott_pd_log_table" style="width:auto;margin-right:162px;" cellspacing="0">
                <thead><tr>
                    <th class="manage-column" scope="col">#</th>
                    <th class="manage-column" id="zapomatic-toptable-siteid" scope="col"><?php _e( 'מזהה חנות', 'zapomatic' ); ?></th>
                    <th class="manage-column" id="zapomatic-toptable-name" scope="col"><?php _e( 'שם חנות', 'zapomatic' ); ?></th>
                    <th class="manage-column" id="zapomatic-toptable-price" scope="col"><?php _e( 'מחיר', 'zapomatic' ); ?></th>
                    <th class="manage-column" id="zapomatic-toptable-type" scope="col"><?php _e( 'סוג', 'zapomatic' ); ?></th>
                    <?php
                    if ( $this->spy ) {
                        ?>
                        <th class="manage-column" id="zapomatic-toptable-spy" scope="col"><?php _e( 'מרגל', 'zapomatic' ); ?></th>
                        <?php
                    }
                    ?>
                </tr></thead>
                <?php
                $i = 1;
                if ( $this->spy ) { $spy = new Zapomatic_Spy; }
                foreach ($_zapbott_pd_log_toptable as $storeline) {
                    echo '<tr class="alternate">';
                    echo '<td class="manage-column">' . $i . '</td>';
                    echo '<td class="manage-column">' . $storeline['id'] . '</td>';
                    echo '<td class="manage-column">' . $storeline['name'] . '</td>';
                    echo '<td class="manage-column">₪' . $storeline['price'] . '</td>';
                    echo '<td class="manage-column" style="color:#' . $this->saleTypeDecode( $storeline['sale_type'] )['color'] . ';">' . $this->saleTypeDecode( $storeline['sale_type'] )['label'] . '</td>';
                    if ( $this->spy ) {
                        echo $spy->render_toptable_spy_row( $storeline['id'], $storeline['name'] );
                    }
                    echo '</tr>';
                    $i++;
                }
                ?>
                </table>
                </p>
                <?php
                }
                ?>
        </div>
        </div>
        <?php
    }

    protected function get_bulk_edit_price_result( $change_type, $change_value, $current_value ) {

        switch ( $change_type ) {
            case '2':
                if (strpos($_REQUEST['_zapbott_pd_zap_min_price'], '%') !== false) {
                    $change_value = $current_value * (1 + ($change_value / 100));
                } else {
                    $change_value = $current_value + $change_value;
                }
                break;
            case '3':
                if (strpos($_REQUEST['_zapbott_pd_zap_min_price'], '%') !== false) {
                    $change_value = $current_value * (1 - ($change_value / 100));
                } else {
                    $change_value = $current_value - $change_value;
                }
                break;
            default:
                $change_value = $change_value;
                break;
        }
        return $change_value;

    }

    protected function get_edit_products_toptable( $array, $price ) {
    
        ob_start();
        $i = 1;
        echo '<div class="zapomatic-toptabletext"><div class="zapomatic-table">';
        foreach ( $array as $storeline ) {
            $color = $price <= $storeline['price'] ? 'green' : 'red';
            echo '<div class="tr" style="background-color:'.esc_attr( $color ).';">';
            echo '<div class="td">' . esc_attr( $i ) . '</div>';
            echo '<div class="td">' . esc_attr( $storeline['name'] ) . '</div>';
            echo '<div class="td">₪' . esc_attr( $storeline['price'] ) . '</div>';
            echo '</div>';
            $i++;
        }
        echo '</div></div>';
        return ob_get_clean();
    
    }

    public function add_category_shipment_cost( $taxonomy ) {
        ?>
        <div class="form-field term-zapmirror">
            <label for="_zapmirror_shipcost"><?php _e( 'אתר מראה - עלות משלוח', 'zapomatic' ); ?></label>
            <input type="text" id="_zapmirror_shipcost" name="_zapmirror_shipcost" style="width:100px;" value="">
        </div>
        <?php
    }

    public function edit_category_shipment_cost( $term, $taxonomy ) {
    
        $term_id = $term->term_id;
        $_zapmirror_shipcost = get_term_meta($term_id, '_zapmirror_shipcost', true);
        ?>
        <tr class="form-field term-zapmirror-wrap">
            <th scope="row"><label for="_zapmirror_shipcost"><?php _e( 'אתר מראה - עלות משלוח', 'zapomatic' ); ?></label></th>
            <td>
                <input type="number" id="_zapmirror_shipcost" name="_zapmirror_shipcost" style="width:100px;" value="<?php echo esc_attr($_zapmirror_shipcost); ?>">
            </td>
        </tr>
        <?php
    }

    public function save_category_shipment_cost( $term_id ) {

        if (isset($_POST['_zapmirror_shipcost']) && '' !== $_POST['_zapmirror_shipcost']) {
            $_zapmirror_shipcost = sanitize_text_field($_POST['_zapmirror_shipcost']);
            update_term_meta($term_id, '_zapmirror_shipcost', $_zapmirror_shipcost);
        } else {
            delete_term_meta($term_id, '_zapmirror_shipcost');
        }
        
    }

    public function get_assigned_models_quantity() {

        $query = new WP_Query( 
            array(
                'post_type'    => 'product',
                'posts_per_page' => '-1',
                'meta_query' => array(
                    'relation' => 'AND',
                    array(
                        'key'     => '_zapbott_pd_zap_modelurl',
                        'value'   => '',
                        'compare' => '!=',
                    ),
                    array(
                        'key'     => '_zapbott_pd_zap_modelurl',
                        'compare' => 'EXISTS',
                    ),
                ),
            ),
         );
         wp_reset_postdata();
         return $query->post_count;

    }

    public static function print_admin_notice( $class, $message ) {
        
        printf( '<div class="notice %1$s"><p><strong>%2$s</strong></p><p>%3$s</p></div>', esc_attr( $class ),  __( 'זאפומטיק', 'zapomatic' ), $message );

    }
    
    protected function saleTypeDecode( $sale_type ) {

        switch ( $sale_type ) {
            case 'smart':
                return array(
                    'label' => __( 'קנייה חכמה', 'zapomatic' ),
                    'color' => '05874c'
                );
            case 'zap':
                return array(
                    'label' => __( 'קנייה בזאפ', 'zapomatic' ),
                    'color' => '5ec7d8'
                );
            case 'regular':
                return array(
                    'label' => __( 'קנייה רגילה', 'zapomatic' ),
                    'color' => 'db3a00'
                );
            default:
                return array(
                    'label' => $sale_type,
                    'color' => 'inherit'
                );
        }
    
    }

}

$GLOBALS['zapomatic_plugin'] =  Zapomatic_Plugin::getInstance();
?>