<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}
?>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;200;300;400;500;600;700;800;900" rel="stylesheet" type="text/css"><!--<![endif]-->
<style>
    * {
        box-sizing: border-box;
    }

    body {
        margin: 0;
        padding: 0;
    }

    a[x-apple-data-detectors] {
        color: inherit !important;
        text-decoration: inherit !important;
    }

    #MessageViewBody a {
        color: inherit;
        text-decoration: none;
    }

    p {
        line-height: inherit
    }

    .desktop_hide,
    .desktop_hide table {
        mso-hide: all;
        display: none;
        max-height: 0px;
        overflow: hidden;
    }

    .image_block img+div {
        display: none;
    }

    sup,
    sub {
        line-height: 0;
        font-size: 75%;
    }

    @media (max-width:620px) {
        .desktop_hide table.icons-inner {
            display: inline-block !important;
        }

        .icons-inner {
            text-align: center;
        }

        .icons-inner td {
            margin: 0 auto;
        }

        .mobile_hide {
            display: none;
        }

        .row-3 .column-1 .block-1.button_block .alignment a,
        .row-3 .column-1 .block-1.button_block .alignment div,
        .row-content {
            width: 100% !important;
        }

        .stack .column {
            width: 100%;
            display: block;
        }

        .mobile_hide {
            min-height: 0;
            max-height: 0;
            max-width: 0;
            overflow: hidden;
            font-size: 0px;
        }

        .desktop_hide,
        .desktop_hide table {
            display: table !important;
            max-height: none !important;
        }

        .row-1 .column-1 .block-1.image_block td.pad {
            padding: 0 !important;
        }

        .row-1 .column-1 .block-1.image_block .alignment div {
            margin: 0 auto 0 0 !important;
        }

        .row-1 .column-2 .block-1.heading_block h1,
        .row-1 .column-2 .block-2.heading_block h3 {
            text-align: right !important;
        }

        .row-2 .column-1 .block-1.heading_block h3,
        .row-2 .column-1 .block-2.heading_block h3,
        .row-2 .column-2 .block-1.heading_block h3,
        .row-2 .column-2 .block-2.heading_block h3,
        .row-2 .column-3 .block-1.heading_block h3,
        .row-2 .column-3 .block-2.heading_block h3,
        .row-2 .column-4 .block-1.heading_block h3,
        .row-2 .column-4 .block-2.heading_block h3,
        .row-7 .column-1 .block-1.heading_block h2,
        .row-8 .column-1 .block-1.heading_block h2,
        .row-9 .column-2 .block-1.heading_block h3 {
            text-align: center !important;
        }

        .row-3 .column-1 .block-1.button_block a,
        .row-3 .column-1 .block-1.button_block div,
        .row-3 .column-1 .block-1.button_block span {
            line-height: 24px !important;
        }

        .row-9 .column-1 .block-1.image_block .alignment div {
            margin: 0 auto !important;
        }
    }
</style><!--[if mso ]><style>sup, sub { font-size: 100% !important; } sup { mso-text-raise:10% } sub { mso-text-raise:-10% }</style> <![endif]-->
<div class="body" style="background-color: #FFFFFF; margin: 0; padding: 0; -webkit-text-size-adjust: none; text-size-adjust: none;">
	<table class="nl-container" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #FFFFFF;">
		<tbody>
			<tr>
				<td>
					<table class="row row-1" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #21759b;">
						<tbody>
							<tr>
								<td>
									<table class="row-content" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="25%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 10px; padding-left: 10px; padding-right: 10px; padding-top: 10px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="image_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="width:100%;padding-right:0px;padding-left:0px;">
																<div class="alignment" align="center" style="line-height:10px">
																	<div style="max-width: 78px;"><img src="<?php echo $data['urls']['zapomatic']; ?>" style="display: block; height: auto; border: 0; width: 100%;" width="78" alt="Zapomatic" title="Zapomatic" height="auto"></div>
																</div>
															</td>
														</tr>
													</table>
												</td>
												<td class="column column-2" width="75%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h1 style="margin: 0; color: #ffffff; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 18px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 21.599999999999998px;"><span style="word-break: keep-all; font-family: inherit; background-color: transparent;"><?php _e( 'דו"ח סיכום סריקה - זאפומטיק', 'zapomatic' ); ?></span></h1>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #b5d6ea; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: 1px; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['start_time']; ?></span></h3>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-2" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="25%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 14.399999999999999px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">🕖 משך</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:10px;padding-left:10px;padding-right:10px;padding-top:5px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['duration']; ?></span></h3>
															</td>
														</tr>
													</table>
												</td>
												<td class="column column-2" width="25%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; border-left: 2px solid #f5f5f8; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 14.399999999999999px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">❕ עצירות</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:10px;padding-left:10px;padding-right:10px;padding-top:5px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['stops']; ?></span></h3>
															</td>
														</tr>
													</table>
												</td>
												<td class="column column-3" width="25%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; border-left: 2px solid #f5f5f8; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 14.399999999999999px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">🔢 מתוך</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:10px;padding-left:10px;padding-right:10px;padding-top:5px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['total']; ?></span></h3>
															</td>
														</tr>
													</table>
												</td>
												<td class="column column-4" width="25%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; border-left: 2px solid #f5f5f8; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 14.399999999999999px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">✅ נסרקו</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:10px;padding-left:10px;padding-right:10px;padding-top:5px;text-align:center;width:100%;">
																<h3 style="margin: 0; color: #000000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['products']; ?></span></h3>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-3" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-bottom: 3px solid #f5f5f8; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="button_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<div class="alignment" align="center"><!--[if mso]>
<v:roundrect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:34px;width:290px;v-text-anchor:middle;" arcsize="15%" stroke="false" fillcolor="#34495e">
<w:anchorlock/>
<v:textbox inset="0px,0px,0px,0px">
<center dir="rtl" style="color:#ffffff;font-family:Tahoma, Verdana, sans-serif;font-size:16px">
<![endif]--><a dir="rtl" href="<?php echo $data['urls']['report']; ?>" target="_blank" style="background-color:#34495e;border-bottom:0px solid transparent;border-left:0px solid transparent;border-radius:5px;border-right:0px solid transparent;border-top:0px solid transparent;color:#ffffff;display:block;font-family:'Roboto', Tahoma, Verdana, Segoe, sans-serif;font-size:16px;font-weight:400;mso-border-alt:none;padding-bottom:5px;padding-top:5px;text-align:center;text-decoration:none;width:50%;word-break:keep-all;"><span style="word-break: keep-all; padding-left: 20px; padding-right: 20px; font-size: 16px; display: inline-block; letter-spacing: 1px;"><span style="word-break: keep-all; line-height: 24px;">מעבר לדו"ח</span></span></a><!--[if mso]></center></v:textbox></v:roundrect><![endif]--></div>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<?php
                    if ( isset( $data['error'] ) ) {
                    ?>
                    <table class="row row-4" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h2 style="margin: 0; color: #21759b; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 16px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 19.2px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">💣 שגיאה קריטית</span></h2>
															</td>
														</tr>
													</table>
													<table class="paragraph_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; word-break: keep-all;">
														<tr>
															<td class="pad">
																<div style="color:red;direction:rtl;font-family:'Roboto', Tahoma, Verdana, Segoe, sans-serif;font-size:14px;font-weight:400;letter-spacing:1px;line-height:120%;text-align:right;mso-line-height-alt:16.8px;">
																	<p style="margin: 0;"><?php echo $data['error']; ?></p>
																</div>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
                    <?php
                    goto end;
                    }
                    ?>
					<table class="row row-5" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h2 style="margin: 0; color: #21759b; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 16px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 19.2px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">📋 סקירה כללית</span></h2>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-6" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-bottom: 3px solid #f5f5f8; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="50%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: green; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['statuses']; ?>=errors" target="_blank" style="text-decoration: underline; color: red;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="94d955ba-a1e7-4a44-a0db-b3fdfb96dcab" data-position="40-0-0" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['statuses']['errors']; ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: green; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['statuses']; ?>=warnings" target="_blank" style="text-decoration: underline; color: orange;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="a05276ca-ced7-4a0d-b291-4f642238c2af" data-position="40-0-1" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['statuses']['warnings']; ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-3" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: green; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['mins']; ?>" target="_blank" style="text-decoration: underline; color: brown;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="9756b1cc-1e2c-489f-accb-de3943270c79" data-position="60-0-2" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['mins']; ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-4" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['!first']; ?>" target="_blank" style="text-decoration: underline; color: #34495e;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="9756b1cc-1e2c-489f-accb-de3943270c79" data-position="60-0-2" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['!first']; ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-5" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: right; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['!assigned']; ?>" target="_blank" style="text-decoration: underline; color: #34495e;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="9756b1cc-1e2c-489f-accb-de3943270c79" data-position="60-0-2" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php echo $data['!assigned']; ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
												</td>
												<td class="column column-2" width="50%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">❌ שגיאות</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">⚠️ אזהרות</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-3" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">🔻 הגיעו למינימום</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-4" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">🥇 לא ראשון בזאפ</span></h3>
															</td>
														</tr>
													</table>
													<table class="heading_block block-5" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 14px; font-weight: 400; letter-spacing: normal; line-height: 120%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 16.8px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">🔗 לא משויכים למודל</span></h3>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-7" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h2 style="margin: 0; color: #21759b; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 16px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 19.2px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">📉 ירידות מחיר</span></h2>
															</td>
														</tr>
													</table>
													<table class="table_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<table style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse; width: 100%; direction: rtl; background-color: transparent; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-weight: 400; color: #000; text-align: right; letter-spacing: 0px; word-break: break-all;" width="100%">
																	<thead style="vertical-align: top; background-color: transparent; color: #34495e; font-size: 14px; line-height: 120%; text-align: right;">
																		<tr>
																			<th width="50%" style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">מוצר</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">מחיר</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">שינוי</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">#1 בזאפ</th>
																		</tr>
																	</thead>
																	<tbody style="vertical-align: top; font-size: 14px; line-height: 120%;">
                                                                        <?php
                                                                        if ( empty( $data['drops'] ) ) {
                                                                            printf(
                                                                                '<tr style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">%s</tr>',
                                                                                __( 'לא נרשמו ירידות מחיר.', 'zapomatic' )
                                                                            );
                                                                        }
                                                                        else {
                                                                            $i = 1;
                                                                            foreach ( $data['drops'] as $product_id => $drop_value ) {
                                                                                $product = wc_get_product( $product_id );
                                                                                $product_price = $product->get_price();
                                                                                $first_price = (int) $product->get_meta( '_zapbott_pd_log_firstprice' );
                                                                                $model_url = $product->get_meta( '_zapbott_pd_zap_modelurl' );
                                                                                printf(
                                                                                    '<tr%s>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><a href="%s" target="_blank" style="text-decoration: underline; color: #34495e;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="9fee21b8-b464-47d2-a1d1-f0645b55fdc5" data-position="60-0-31100170-05a4-449f-8bf1-97bc16df6240-1-0" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;">%s</span></span></a></td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">%s</td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><span style="word-break: keep-all; color: #ff0000;">%s</span></td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><a href="%s" target="_blank" style="text-decoration: underline; color: #%s;" rel="noopener">%s</a></td>
                                                                                    </tr>',
                                                                                    $i % 2 == 0 ? null : ' style="background-color:#f5f5f8;"',
                                                                                    esc_url( add_query_arg( array(
                                                                                        'post' => $product_id,
                                                                                        'action' => 'edit',
                                                                                        ),
                                                                                        get_admin_url() . 'post.php'
                                                                                    ) ),
                                                                                    $product->get_name(),
                                                                                    wc_price( $product_price ),
                                                                                    wc_price( $drop_value ),
                                                                                    $model_url,
                                                                                    $first_price < $product_price ? 'ff0000' : '008000',
                                                                                    wc_price( $first_price )
                                                                                );
                                                                                $i++;
                                                                            }
                                                                        }
                                                                        ?>
																	</tbody>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-8" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="padding-bottom:5px;padding-left:10px;padding-right:10px;padding-top:10px;text-align:center;width:100%;">
																<h2 style="margin: 0; color: #21759b; direction: rtl; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 16px; font-weight: 700; letter-spacing: normal; line-height: 120%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 19.2px;"><span class="tinyMce-placeholder" style="word-break: keep-all;">📈 עליות מחיר</span></h2>
															</td>
														</tr>
													</table>
													<table class="table_block block-2" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<table style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse; width: 100%; direction: rtl; background-color: transparent; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-weight: 400; color: #000; text-align: right; letter-spacing: 0px; word-break: break-all;" width="100%">
																	<thead style="vertical-align: top; background-color: transparent; color: #34495e; font-size: 14px; line-height: 120%; text-align: right;">
																		<tr>
																			<th width="50%" style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">מוצר</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">מחיר</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">שינוי</th>
																			<th style="padding: 10px; word-break: keep-all; font-weight: 700; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">#1 בזאפ</th>
																		</tr>
																	</thead>
																	<tbody style="vertical-align: top; font-size: 14px; line-height: 120%;">
                                                                        <?php
                                                                        if ( empty( $data['rises'] ) ) {
                                                                            printf(
                                                                                '<tr style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">%s</tr>',
                                                                                __( 'לא נרשמו עליות מחיר.', 'zapomatic' )
                                                                            );
                                                                        }
                                                                        else {
                                                                            $i = 1;
                                                                            foreach ( $data['rises'] as $product_id => $rise_value ) {
                                                                                $product = wc_get_product( $product_id );
                                                                                $product_price = $product->get_price();
                                                                                $first_price = (int) $product->get_meta( '_zapbott_pd_log_firstprice' );
                                                                                $model_url = $product->get_meta( '_zapbott_pd_zap_modelurl' );
                                                                                printf(
                                                                                    '<tr%s>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><a href="%s" target="_blank" style="text-decoration: underline; color: #34495e;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="9fee21b8-b464-47d2-a1d1-f0645b55fdc5" data-position="60-0-31100170-05a4-449f-8bf1-97bc16df6240-1-0" data-qa="tinyeditor-root-element">%s</span></a></td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;">%s</td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><span style="word-break: keep-all; color: #008000;">+%s</span></td>
                                                                                    <td style="padding: 10px; word-break: keep-all; border-top: 0px solid transparent; border-right: 0px solid transparent; border-bottom: 0px solid transparent; border-left: 0px solid transparent;"><a href="%s" target="_blank" style="text-decoration: underline; color: #%s;" rel="noopener">%s</a></td>
                                                                                    </tr>',
                                                                                    $i % 2 == 0 ? null : ' style="background-color:#f5f5f8;"',
                                                                                    esc_url( add_query_arg( array(
                                                                                        'post' => $product_id,
                                                                                        'action' => 'edit',
                                                                                        ),
                                                                                        get_admin_url() . 'post.php'
                                                                                    ) ),
                                                                                    $product->get_name(),
                                                                                    wc_price( $product_price ),
                                                                                    wc_price( $rise_value ),
                                                                                    $model_url,
                                                                                    $first_price < $product_price ? 'ff0000' : '008000',
                                                                                    wc_price( $first_price )
                                                                                );
                                                                                $i++;
                                                                            }
                                                                        }
                                                                        ?>
																	</tbody>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
                    <?php end: ?>
					<table class="row row-9" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; border-top: 3px solid #f5f5f8; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="50%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="image_block block-1" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad" style="width:100%;padding-right:0px;padding-left:0px;">
																<div class="alignment" align="right" style="line-height:10px">
																	<div style="max-width: 75px;"><a href="https://tovel.co.il/" target="_blank" style="outline:none" tabindex="-1"><img src="<?php echo $data['urls']['tovel']; ?>" style="display: block; height: auto; border: 0; width: 100%;" width="75" alt="tovel web solutions" title="tovel web solutions" height="auto"></a></div>
																</div>
															</td>
														</tr>
													</table>
												</td>
												<td class="column gap" style="vertical-align: top; mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left;">
													<table style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 5px; height: 5px;" width="5" height="5"></table>
												</td>
												<td class="column column-2" width="50%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: middle; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 700; letter-spacing: normal; line-height: 150%; text-align: left; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 18px;"><a href="https://tovel.co.il/product/zapomatic/" target="_blank" style="text-decoration: none; color: #34495e;" rel="noopener"><u>Zapomatic</u><br>tovel web solutions ©</a><br></h3>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
					<table class="row row-10" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
						<tbody>
							<tr>
								<td>
									<table class="row-content stack" align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-radius: 0; border-top: 3px solid #f5f5f8; color: #000000; width: 600px; margin: 0 auto;" width="600">
										<tbody>
											<tr>
												<td class="column column-1" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; font-weight: 400; text-align: left; padding-bottom: 5px; padding-top: 5px; vertical-align: top; border-top: 0px; border-right: 0px; border-bottom: 0px; border-left: 0px;">
													<table class="heading_block block-1" width="100%" border="0" cellpadding="10" cellspacing="0" role="presentation" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
														<tr>
															<td class="pad">
																<h3 style="margin: 0; color: #000; direction: ltr; font-family: 'Roboto', Tahoma, Verdana, Segoe, sans-serif; font-size: 12px; font-weight: 400; letter-spacing: normal; line-height: 150%; text-align: center; margin-top: 0; margin-bottom: 0; mso-line-height-alt: 18px;"><span class="tinyMce-placeholder" style="word-break: keep-all;"><a href="<?php echo $data['urls']['settings']; ?>" target="_blank" style="text-decoration: none; color: #34495e;" rel="noopener"><span class="mce-content-body mce-edit-focus" style="word-break: keep-all; position: relative;" id="3b8d379b-14ab-4b4d-8941-31c53b764b78" data-position="90-0-0" data-qa="tinyeditor-root-element"><span class="tinyMce-placeholder" style="word-break: keep-all;"><?php _e( 'לשינוי תדירות וסוג הדו"ח לחץ כאן', 'zapomatic' ); ?></span></span></a></span></h3>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</tbody>
									</table>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
		</tbody>
	</table><!-- End -->
</div>