<?php
if ( ! defined( 'ABSPATH' ) ) die;
if ( ! class_exists( 'WP_List_Table' ) ) require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
final class Zapomatic_Tools {


    public function __construct() {

    }

    public function register_hooks() {

        add_action( 'wp_ajax_zapomatic_import_models', array( $this, 'ajax_import_models' ) );
        add_action( 'wp_ajax_zapomatic_import_data', array( $this, 'ajax_import_data' ) );
    }

    public function print_tools() {
        
        $tab = $this->menu_tabs( isset($_GET['tab']) ? $_GET['tab'] : null );
        ?>
        <div class="wrap woocommerce">
            <h1><?php _e( 'כלים - זאפומטיק', 'zapomatic' ); ?></h1>
            <nav class="nav-tab-wrapper woo-nav-tab-wrapper">
                <a href="?page=zapomatic_tools" class="nav-tab <?php if($tab['key']==='import-models'):?>nav-tab-active<?php endif; ?>">ייבוא מודלים</a>
                <a href="?page=zapomatic_tools&tab=import-data" class="nav-tab <?php if($tab['key']==='import-data'):?>nav-tab-active<?php endif; ?>">ייבוא נתונים</a>
                <a href="?page=zapomatic_tools&tab=advanced" class="nav-tab <?php if($tab['key']==='advanced'):?>nav-tab-active<?php endif; ?>">מתקדם</a>
            </nav>
            <?php echo $this->menu_tabs_callback( $tab['key'] ); ?>
        </div>
        <?php
    }

    protected function menu_tabs( $tab = null ) {
        switch ( $tab ) {
            case 'import-data':
                return array(
                    'key'   => 'import-data',
                    'title' => __('ייבוא מוצרים', 'zapomatic')
                );
            case 'advanced':
                return array(
                    'key'   => 'advanced',
                    'title' => __('מתקדם', 'zapomatic')
                );
            default:
                return array(
                    'key'   => 'import-models',
                    'title' => __('ייבוא מודלים', 'zapomatic')
                );
        }

    }

    protected function menu_tabs_callback( $tab = 'import-models' ) {

        switch ( $tab ) {
            case 'import-data':
                return $this->display_import_data();
            case 'advanced':
                if ( wp_verify_nonce( sanitize_text_field( @$_REQUEST['_wpnonce'] ), 'tools-advanced' ) ) {
                    $action = sanitize_text_field( $_REQUEST['action'] );
                    require_once( 'class-database.php' );
                    $db = new Zapomatic_Database;
                    switch ( $action ) {
                        case 'do_fullexec':
                            if ( $db->is_full_exec() ) {
                                Zapomatic_Plugin::print_admin_notice( 'notice-error', __( 'אירעה שגיאה בהפעלת סריקה מלאה: זוהתה סריקה מלאה פעילה המתבצעת ברקע', 'zapomatic' ) );
                            }
                            else {
                                if ( $do_fullexec = wp_schedule_single_event( time(), 'zapbott_full_exec_hook', array(), true ) === true ) {
                                    Zapomatic_Plugin::print_admin_notice( 'updated', __( 'סריקה מלאה הופעלה בהצלחה!', 'zapomatic' ) );
                                }
                                else {
                                    Zapomatic_Plugin::print_admin_notice( 'notice-error', sprintf( __( 'אירעה שגיאה בהפעלת סריקה מלאה: %s', 'zapomatic' ), $do_fullexec ) );
                                }
                            }
                            
                            break;
                        case 'reset_fullexec':
                            $reset_fullexec = $db->abort_active_exec();
                            if ( $reset_fullexec ) Zapomatic_Plugin::print_admin_notice( 'updated', __( 'איפוס סריקה הושלם בהצלחה!', 'zapomatic' ) );
                            elseif ( $reset_fullexec === null ) Zapomatic_Plugin::print_admin_notice( 'notice-error', __( 'אירעה שגיאה באיפוס הסריקה: לא זוהתה סריקה פעילה!', 'zapomatic' ) );
                            else Zapomatic_Plugin::print_admin_notice( 'notice-error', sprintf( __( 'אירעה שגיאה באיפוס הסריקה: %s', 'zapomatic' ), $reset_fullexec ) );
                            break;
                        default:
                            Zapomatic_Plugin::print_admin_notice( 'notice-error', 'פעולה לא ידועה' );
                            break;
                    }
                }
                return $this->display_advanced();
            default: 
                return $this->display_import_models();
        }

    }

    protected function display_import_data() {
        ?>
        <div class="zapomatic-progress-form-wrapper">
            <ol class="zapomatic-progress-steps">
                <li class="active">העלאת קובץ CSV</li>
                <li class="">מיפוי עמודות</li>
                <li class="">ייבוא</li>
                <li class="">בוצע!</li>
            </ol>
            <div class="zapomatic-progress-form-content zapomatic-data-importer" enctype="multipart/form-data" method="post">
                <header>
                    <h2 id="zapomatic-idata-title">ייבוא מוצרים מקובץ CSV</h2>
                    <p id="zapomatic-idata-title-desc">הכלי הזה מאפשר לך לייצא (או לאחד) נתוני מוצר בחנות שלך באמצעות קובץ CSV.</p>
                </header>
                <section id="zapomatic-idata-section">
                    <table class="form-table zapomatic-importer-options">
                        <tbody>
                            <tr>
                                <th scope="row">
                                    <label for="upload">בחר קובץ CSV מהמחשב:</label>
                                </th>
                                <td>
                                    <input type="file" id="zapomatic-idata-file" name="import" accept=".csv" size="25" />
                                    <br />
                                    <small>גודל מקסימלי: 499 MB</small>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </section>
                <div class="zapomatic-actions">
                    <button class="button button-primary button-next" id="zapomatic-idata-submit" value="המשך" name="upload">המשך</button>
                </div>
            </div>
        </div>
        <?php
    }

    public function ajax_import_data() {

        $file = $_FILES['zapomatic-idata-file'];
        if ( empty( $file ) ) {
            wp_send_json_error(
                array(
                    'message' => 'No file uploaded.',
                )
            );
            wp_die();
        }
        $file_type = wp_check_filetype($file['name']);
        if ($file_type['ext'] !== 'csv') {
            wp_send_json_error(
                array(
                    'message' => 'Please upload a valid CSV file.',
                )
            );
            wp_die();
        }
        $upload = wp_handle_upload($file, array('test_form' => false));
        if (isset($upload['error'])) {
            wp_send_json_error(
                array(
                    'message' => $upload['error'],
                )
            );
        }
        $upload_dir = wp_upload_dir();
        $uploaded_file_path = $upload_dir['basedir'] . '/' . basename($file['name']);
        $map = stripslashes( $_REQUEST['zapomatic-idata-map'] );
        $map = (array) json_decode( $map );
        $product_id = (int) $_REQUEST['zapomatic-idata-product-id'];
        $product_index = (int) $_REQUEST['zapomatic-idata-product-index'];
        switch ( $_REQUEST['step'] ) {
            case 'upload':
                wp_send_json_success(
                    array(
                        'file_path' => $uploaded_file_path,
                        'file_data' => $this->data_import_process_file( $uploaded_file_path, true ),
                    )
                );
                break;
            case 'map':
                $uid_index = array_search( '_unique_id', $map );
                if ( $uid_index === false ) wp_die('no unique id!');
                unset( $map[ $uid_index ] );
                if ( empty( $map ) ) {
                    wp_send_json_error(
                        array(
                            'message' => 'no map fields selected!',
                        )
                    );
                }
                $csv = $this->data_import_process_file( $uploaded_file_path );
                $csv_columns_keys = array_keys($csv[0]);
                $uid_column = $csv_columns_keys[$uid_index];
                $filtered_map = [];
                foreach ( $map as $col_index => $meta_key ) {
                    $filtered_map[$meta_key] = $csv_columns_keys[$col_index];
                }
                wp_send_json_success(
                    array(
                        'filtered_map' => $filtered_map,
                        'filtered_lines' => $this->generate_mapped_product_ids( $csv, $uid_column ),
                    )
                );
                break;
            case 'update':
                if ( !empty( $product_id ) ) {
                    $product = @wc_get_product( $product_id );
                    if ( !is_object( $product ) ) {
                        wp_send_json_error(
                            array(
                                'message' => "$product_id is not a product object!",
                            )
                        );
                    }
                    $csv = $this->data_import_process_file( $uploaded_file_path );
                    $mapped = stripslashes( $_REQUEST['zapomatic-idata-mapped'] );
                    $mapped = (array) json_decode( $mapped );
                    $results = [];
                    foreach ( $mapped as $meta_key => $column_name ) {
                        $value = $csv[$product_index][$column_name];
                        update_post_meta( $product_id, $meta_key, $value );
                        $results[] = sprintf(
                            '%s %d %s %d: %s %d - %s %s %s: %s',
                            __( 'שורה', 'zapomatic' ),
                            $product_index+1,
                            __( 'מתוך', 'zapomatic' ),
                            count( $csv ),
                            __( 'מוצר', 'zapomatic' ),
                            $product_id,
                            __( 'עודכן', 'zapomatic' ),
                            $this->decode_product_meta_key( $meta_key ),
                            __( 'עם ערך', 'zapomatic' ),
                            $value,
                        );
                    }
                    wp_send_json_success(
                        array(
                            'results' => $results
                        )
                    );
                }
                else {
                    wp_send_json_error(
                        array(
                            'message' => 'no $product_id retrieved from the ajax call!',
                        )
                    );
                }
                break;
        }
        $this->delete_file( $uploaded_file_path );
        wp_die();

    }
    
    private function decode_product_meta_key( $meta_key ) {
        
        switch ( $meta_key ) {
            case '_zapbott_pd_zap_modelurl':
                return __( 'קישור לעמוד המוצר בזאפ', 'zapomatic' );
            case '_zapbott_pd_zap_required_position':
                return __( 'לפי מקום', 'zapomatic' );
            case '_zapbott_pd_zap_price_drop':
                return __( 'בכמה', 'zapomatic' );
            case '_zapbott_pd_zap_min_price':
                return __( 'מחיר מינימום', 'zapomatic' );
            case '_zapbott_pd_zap_max_price':
                return __( 'מחיר מקסימום', 'zapomatic' );
            case '_zapbott_pd_zap_default_price':
                return __( 'מחיר ברירת מחדל', 'zapomatic' );
            case '_zapmirror_product_name':
                return __( 'שם מוצר לזאפ', 'zapomatic' );
            case '_zapmirror_product_description':
                return __( 'תיאור מוצר לזאפ', 'zapomatic' );
            default:
                return __( 'לא ידוע', 'zapomatic' );

        }

    }

    private function generate_mapped_product_ids( $csv, $uid_column ) {

        $arr = [];
        $i = 0;
        foreach ( $csv as $row ) {
            if ( empty( $row[ $uid_column ] ) ) {
                $arr[] = array(
                    'index' => $i,
                    'product_id' => null,
                );
                $i++;
                continue;
            }
            $product_id = wc_get_product_id_by_sku( $row[ $uid_column ] );
            if ( ! $product_id ) $product_id = wc_get_product_id_by_sku( str_replace( [ '-', ' ' ], '', $row[ $uid_column ] ) );
            if ( ! $product_id ) {
                $arr[] = array(
                    'index' => $i,
                    'product_id' => false,
                );
                $i++;
                continue;
            }
            foreach ($arr as $e) {
                if ($e['product_id'] == $product_id) {
                    $arr[] = array(
                        'index' => $i,
                        'product_id' => true,
                    );
                    $i++;
                    continue;
                }
            }
            $arr[] = array(
                'index' => $i,
                'product_id' => $product_id,
            );
            $i++;
        }
        return $arr;

    }

    private function data_import_process_file($file, $sample_only = false) {

        $handle = fopen($file, 'r');
        $csv = [];
        if ($handle !== FALSE) {
            $headers = fgetcsv($handle);
            if ($headers !== false) {
                $headers[0] = str_replace("\xEF\xBB\xBF", '', $headers[0]);
                $headerString = implode(',', $headers);
                $encoding = @mb_detect_encoding($headerString, 'UTF-8, Windows-1255', true);    
                if ($encoding !== 'UTF-8') {
                    $headers = array_map(function($header) {
                        $convertedHeader = iconv('Windows-1255', 'UTF-8//IGNORE', $header);
                        return $convertedHeader;
                    }, $headers);
                }
                $headers = array_map('trim', array_map(function($header) {
                    return trim($header, '"');
                }, $headers));
                while (($row = fgetcsv($handle)) !== FALSE) {
                    if (empty($row)) {
                        continue;
                    }
                    $rowString = implode(',', $row);
                    $encoding = @mb_detect_encoding($rowString, 'UTF-8, Windows-1255', true);
                    if ($encoding !== 'UTF-8') {
                        $convertedRow = array_map(function($value) use ($encoding) {
                            if (trim($value) === '') {
                                return '';
                            }
                            if ($encoding === 'Windows-1255') {
                                return iconv('Windows-1255', 'UTF-8//IGNORE', $value);
                            } else {
                                return iconv('ISO-8859-8', 'UTF-8//IGNORE', $value);
                            }
                        }, $row);
                        $row = $convertedRow;
                    }
                    $row = array_map('trim', array_map(function($value) {
                        return trim($value, '"');
                    }, $row));
                    if (count($headers) === count($row)) {
                        $csv[] = array_combine($headers, $row);
                    }
                }
            }
            fclose($handle);
        }
        return $sample_only ? $csv[0] : $csv;

    }
    
    private function delete_file( $file_path ) {

        if ( file_exists( $file_path ) ) {
            if ( unlink( $file_path ) ) {
                return array( 'success' => true, 'message' => 'File deleted successfully.' );
            } else {
                return array( 'success' => false, 'message' => 'Failed to delete the file.' );
            }
        } else {
            return array( 'success' => false, 'message' => 'File does not exist.' );
        }
    }

    public function ajax_import_models() {

        $data = stripslashes($_REQUEST['data']);
        $data = json_decode($data);
        
        $product_id = $data->product_id;
        $model_url = $data->model_url;
        
        $product = @wc_get_product( $product_id );
        if ( empty( $product ) || !empty( @get_post_meta( $product_id, '_zapbott_pd_zap_modelurl', true ) ) ) $result = false;
        else {
            update_post_meta( $product_id, '_zapbott_pd_zap_modelurl', $model_url );
            $result = true;
        } 
        echo json_encode($result);
        exit;

    }

    protected function display_import_models() {
        
        if ( isset($_POST['zapomatic_import_models_submit']) ) {
                $obj = new Zapomatic_Import_Models_Table;
                $obj->file_arr = $_FILES['zapomatic_import_models_file'];
                $obj->prepare_items();
                $obj->display();
            return;
        }
        ?>
        <div class="zapomatic-upload-box">
            <div class="zapomatic-upload-box-inner">
                <h2><?php _e( 'ייבוא מודלים מקובץ זאפ', 'zapomatic' ); ?></h2>
                <label for="tf2c_files"><?php _e( 'בחירת קובץ', 'woocommerce' ); ?>:</label>
                <input form="zapomatic_import_models" type="file" name="zapomatic_import_models_file" id="zapomatic_import_models_file" accept=".csv" required /><br />
                <input form="zapomatic_import_models" type="submit" class="button button-hero" value="<?php _e('המשך', 'woocommerce'); ?>" name="zapomatic_import_models_submit" />
            </div>
            <p class="max-upload-size">גודל קובץ מקסימלי: 499 MB.</p>
        </div>
        <?php
    }

    protected function display_advanced() {

        $nonce = wp_create_nonce( 'tools-advanced' );
        ?>
        <form id="form_zapomatic_tools_do_fullexec" method="GET" action="<?php echo get_admin_url() . 'admin.php'; ?>">
            <input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo $nonce; ?>">
            <input type="hidden" name="page" value="zapomatic_tools">
            <input type="hidden" name="tab" value="advanced">
            <input type="hidden" name="action" value="do_fullexec">
	    </form>
        <form id="form_zapomatic_tools_reset_fullexec" method="GET" action="<?php echo get_admin_url() . 'admin.php'; ?>">
            <input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo $nonce; ?>">
            <input type="hidden" name="page" value="zapomatic_tools">
            <input type="hidden" name="tab" value="advanced">
            <input type="hidden" name="action" value="reset_fullexec">
	    </form>
        <table class="wc_status_table wc_status_table--tools widefat" cellspacing="0">
            <tbody class="tools">
                <tr class="do_fullexec">
                    <th>
                        <strong class="name"><?php _e( 'בצע עדכון מלא', 'zapomatic' ); ?></strong>
                        <p class="description"><?php _e( 'הרץ עדכון מוצרים ידני מלא בזמן אמת', 'zapomatic' ); ?></p>
                    </th>
                    <td class="run-tool">
                        <input type="submit" form="form_zapomatic_tools_do_fullexec" class="button button-large" value="<?php _e( 'בצע עדכון!', 'zapomatic' ); ?>">
                    </td>
                </tr>
                <tr class="reset_fullexec">
                    <th>
                        <strong class="name"><?php _e( 'איפוס סריקה', 'zapomatic' ); ?></strong>
                        <p class="description"><?php _e( 'ביטול ואיפוס סריקה נוכחית', 'zapomatic' ); ?></p>
                    </th>
                    <td class="run-tool">
                        <input type="submit" form="form_zapomatic_tools_reset_fullexec" class="button button-large" value="<?php _e( 'בצע איפוס!', 'zapomatic' ); ?>">
                    </td>
                </tr>
            </tbody>
        </table>
        <div class="clear"></div>
        <?php
    }
    
}
class Zapomatic_Import_Models_Table extends WP_List_Table {

    public $file_arr;

    public function prepare_items() {
        
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = array();
        $data = $this->table_data();
        $this->items = $data;
        $this->_column_headers = array($columns, $hidden, $sortable, 'product_id');
        
    }

    public function get_columns() {

        $columns = array(
            'product_id'   => __( 'מזהה מוצר', 'zapomatic' ),
            'product_name' => __( 'שם מוצר', 'zapomatic' ),
            'model_url'    => __( 'עמוד מודל בזאפ', 'zapomatic' ),
            'action'       => __( 'פעולה', 'zapomatic' )
        );
        return $columns;

    }

    private function table_data() {

        $file_to_read = fopen( $this->file_arr['tmp_name'], 'r' );
        if($file_to_read === FALSE) return false;

        $arr = [];
        while ( ( $line = fgetcsv($file_to_read) ) !== FALSE ) {
            if ( filter_var( $line[2], FILTER_VALIDATE_URL ) && filter_var( $line[8], FILTER_VALIDATE_URL ) ) {
                $url_components = parse_url( $line[2] );
                parse_str( $url_components['query'], $params );
                $product_id = $params['p'];
                if ( empty( @get_post_meta( $product_id, '_zapbott_pd_zap_modelurl', true ) ) ) {
                    $arr[] = array(
                        'product_id' => $product_id,
                        'model_url' => preg_replace('/^http:\/\//', 'https://', $line[8] )
                    );
                }
            }
        }
        fclose($file_to_read);
        return $arr;

    }

    public function column_default( $item, $column_name ) {

        switch( $column_name ) {
            case 'product_id':
                return $item[ $column_name ];
            case 'product_name':
                return sprintf(
                    '<a href="'.get_admin_url().'post.php?post=%s&action=edit" target="_blank">%s</a>',
                    $item[ 'product_id' ],
                    get_the_title($item[ 'product_id' ])
                );
            case 'model_url':
                $url_components = parse_url( $item[ $column_name ] );
                parse_str( $url_components['query'], $params );
                $model_id = $params['modelid'];
                return sprintf(
                    '<a href="%s" target="_blank">%s</a>',
                    $item[ $column_name ],
                    $model_id
                );
            case 'action':
                return sprintf(
                    '<a class="button zapomatic-associate" model_url="%s" product_id="%s" title="%s" target="_blank" onclick="event.preventDefault();">%s</a>
                    <span class="spinner" style="float:initial;"></span>',
                    $item[ 'model_url' ],
                    $item[ 'product_id' ],
                    __( 'שייך עמוד מודל למוצר', 'zapomatic' ),
                    __( 'שיוך', 'zapomatic' )
                );
            default:
                return print_r( $item, true );
        }

    }

    private function sort_data( $a, $b ) {
        // Set defaults
        $orderby = 'title';
        $order = 'asc';

        // If orderby is set, use this as the sort column
        if(!empty($_GET['orderby']))
        {
            $orderby = $_GET['orderby'];
        }

        // If order is set use this as the order
        if(!empty($_GET['order']))
        {
            $order = $_GET['order'];
        }


        $result = strcmp( $a[$orderby], $b[$orderby] );

        if($order === 'asc')
        {
            return $result;
        }

        return -$result;
    }
}
?>