<?php
if ( ! defined( 'ABSPATH' ) ) die;
require_once( ABSPATH . 'wp-content/plugins/woocommerce/includes/emails/class-wc-email.php' );
if ( class_exists( 'WC_Email' ) ) {
    class Zapomatic_Email extends WC_Email {

        private $db;
        private $overview;

        public function __construct() {

            $this->init_db();
            $this->init_overview();
            $this->id          = 'zapomatic_email';
            $this->title       = __( 'Zapomatic Last Execution Report Email', 'zapomatic' );
            $this->description = __( 'Sends a report email with details from the last execution.', 'zapomatic' );
            if ( ! $recipient = @get_option( 'zapbott_option_sendreport_mail' ) ) $recipient = get_option( 'admin_email' );
            $this->recipient = $recipient;
            $exec_values = $this->db->get_last_exec_values( array( 'start_time' ), 'completed' );
            $this->subject     = sprintf( __( 'סיכום סריקה %s', 'zapomatic' ) , $this->overview->get_formatted_datetime( $exec_values['start_time'] ) );
            $this->heading     = __( 'Details of Last Execution', 'zapomatic' );
            $this->template_html = 'email-report.php';
            parent::__construct();
        }

        private function init_db() {

            if ( $this->db ) return;
            require_once('class-database.php');
            $this->db = new Zapomatic_Database;
            return;
        }

        protected function init_overview() {

            if ( $this->overview ) return;
            require_once( 'class-overview.php' );
            $this->overview = new Zapomatic_Overview;
            return;
    
        }

        private function prepare() {

            global $zapbott_license;
            $last_exec = $this->db->get_last_completed_exec();
            $start_time = $last_exec->start_time;
            $data['start_time'] = $this->overview->get_formatted_datetime( $start_time );
            $products_data = $this->db->get_row_value( $last_exec, 'products_data' );
            $data['products'] = count( $products_data );
            $data['total'] = $last_exec->total;
            $data['stops'] = $last_exec->stops;
            $end_time = $last_exec->end_time;
            $data['duration'] = $this->overview->get_runtime( $start_time, $end_time );
            if ( !empty( $last_exec->error ) ) {
                $data['error'] = $last_exec->error;
                return $data;
            }
            if ( ! empty( $zapbott_license->error ) ) {
                $data['error'] = sprintf(
                    '<b style="color:red;">%s: %s</b>',
                    __( 'שגיאת רישיון', 'zapomatic' ),
                    Zapbott_License::statusDecode( $zapbott_license->error )
                );
                return $data;
            }
            $data['statuses'] = $this->overview->map_exec_products_statuses( $products_data, true );
            $data['mins'] = $this->overview->get_products_data_totals( $products_data, 'is_minimum' );
            $data['!first'] = $this->overview->get_products_data_totals( $products_data, 'isnt_first' );
            $data['!assigned'] = $this->overview->get_products_data_totals( $products_data, 'isnt_assigned' );
            $movements = $this->overview->get_exec_products_price_movements( $products_data );
            $data['drops'] = $movements['drops'];
            $data['rises'] = $movements['rises'];
            $date = explode( ' ', $start_time )[0];
            $data['urls']['report'] = add_query_arg( array(
                'page' => 'zapomatic',
                'selected_date' => $date,
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['statuses'] = add_query_arg( array(
                'page' => 'zapomatic',
                'selected_date' => $date,
                'status' => ''
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['mins'] = add_query_arg( array(
                'page' => 'zapomatic',
                'selected_date' => $date,
                'is_minimum' => 'true'
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['!first'] = add_query_arg( array(
                'page' => 'zapomatic',
                'selected_date' => $date,
                'is_first' => 'false'
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['!assigned'] = add_query_arg( array(
                'page' => 'zapomatic',
                'selected_date' => $date,
                'is_assigned' => 'false'
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['settings'] = add_query_arg( array(
                'page' => 'zapomatic_settings',
                ),
                get_admin_url() . 'admin.php'
            );
            $data['urls']['tovel'] = sprintf('%simages/tovel.png', ZAPOMATIC_URL);
            $data['urls']['zapomatic'] = sprintf('%simages/zapomatic.png', ZAPOMATIC_URL);
            return $data;

        }

        public function trigger() {
            
            $exec_data = $this->prepare();
            if ( ! $exec_data ) return;
            if ( ! $this->is_enabled() || ! $this->get_recipient() ) return;
            $trigger = false;
            $report_type = @get_option( 'zapbott_option_sendreport_type' );
            if ( $report_type == 'full' ) $trigger = true;
            elseif ( $report_type == 'errors' ) {
                if ( isset( $exec_data['error'] ) || $exec_data['statuses']['errors'] > 0 ) $trigger = true;
            }
            elseif ( $report_type == 'custom' ) {
                if ( isset( $exec_data['error'] ) || $exec_data['statuses']['errors'] > 0 ) $trigger = true;
                $report_type_custom = (int) get_option( 'zapbott_option_sendreport_type_custom', 2 );
                if ( $trigger === false ) {
                    foreach ( $exec_data['drops'] as $value ) {
                        if ( abs( $value ) >= $report_type_custom ) {
                            $trigger = true;
                            break;
                        }
                    }
                }
                if ( $trigger === false ) {
                    foreach ( $exec_data['rises'] as $value ) {
                        if ( abs( $value ) >= $report_type_custom ) {
                            $trigger = true;
                            break;
                        }
                    }
                }
            }
            if ( $trigger !== true ) return; 
            $this->object = $exec_data;
            $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
        
        }

        public function get_content_html() {

            return wc_get_template_html( $this->template_html, array(
                'data'     => $this->object,
                'email_heading' => $this->get_heading(),
                'email'         => $this,
            ), '', ZAPOMATIC_DIR . 'templates/' );

        }

        public function get_content_plain() {

            return false;

        }

    }
    
}
?>