const rtCanvas = document.getElementById('rt-canvas');
let rtChart;
rtChart = new Chart(rtCanvas, {
    type: 'line',
    data: {
        labels: zapomatic_localized.labels.x,
        datasets: [
          {
            label: zapomatic_localized.labels.runtime,
            data: zapomatic_localized.runtime,
            borderWidth: 2,
            borderColor: 'rgb(0,0,125)',
            backgroundColor: 'rgba(0,0,125, 0.5)',
            yAxisID: 'y1',
          },
          {
            label: zapomatic_localized.labels.products,
            data: zapomatic_localized.products,
            borderWidth: 2,
            borderColor: 'rgb(0,128,0)',
            backgroundColor: 'rgba(0,128,0, 0.5)',
            yAxisID: 'y',
          },
          {
            label: zapomatic_localized.labels.stops,
            data: zapomatic_localized.stops,
            borderWidth: 2,
            borderColor: 'rgb(139, 0, 0)',
            backgroundColor: 'rgba(139, 0, 0, 0.5)',
            yAxisID: 'y',
          },
        ],
      },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        plugins: {
            tooltip: {
                mode: 'index',
                intersect: false,
                callbacks: {
                  title: function(context) {
                    return zapomatic_localized.labels.tooltips[context[0].dataIndex];
                  },
                  label: function(tooltipItem) {
                    let label = tooltipItem.dataset.label || '';
                    if (label) {
                      label += ': ';
                    }
                    label += (tooltipItem.dataset.label === zapomatic_localized.labels.runtime) ? zapomatic_localized.runtime_str[tooltipItem.dataIndex] : formatNumber(tooltipItem.raw); // Get the raw data value
                    return label;
                  },
                },
            },
            legend: {
                display: true,
                position: 'right',
            },
            title: {
                display: false,
            },
            customCanvasBackgroundColor: {
                color: 'white',
            },
        },
        interaction: {
            mode: 'index',
            intersect: false
        },
        scales: {
          x: {
          },
          y: {
            type: 'linear',
            display: false,
            stacked: false
          },
          y1: {
            type: 'linear',
            display: false,
            stacked: false
          },
        }
  },
});
function formatNumber(value) {
  return new Intl.NumberFormat('en-US').format(value);
}