const ptCanvas = document.getElementById('pt-canvas');
let ptChart;
ptChart = new Chart(ptCanvas, {
  type: 'line',
  data: {
      labels: zapomatic_localized.data.labels,
      datasets: zapomatic_localized.data.datasets
    },
  options: {
      responsive: true,
      maintainAspectRatio: true,
      scales: {
        y: {
          display: false,
          stacked: false,
        },
      },
      plugins: {
          tooltip: {
              mode: 'nearest',
              intersect: true,
              callbacks: {
                title: function(context) {
                  return zapomatic_localized.data.tooltips_labels[context[0].dataIndex];
                },
                label: function(tooltipItem) {
                  let label = tooltipItem.dataset.label || '';
                  if (label) {
                    label += ': ';
                  }
                  label += '₪' + formatNumber(tooltipItem.raw);
                  return label;
                },
              },
              rtl: true,
              textDirection: 'rtl',
          },
          legend: {
              display: true,
              position: 'bottom',
              onHover: (event, legendItem) => {
                const datasetIndex = legendItem.datasetIndex;
                ptChart.data.datasets[datasetIndex].borderDash = [5, 5];
                ptChart.update();
              },
              onLeave: (event, legendItem) => {
                  const datasetIndex = legendItem.datasetIndex;
                  ptChart.data.datasets[datasetIndex].borderDash = [0];
                  ptChart.update();
              },
              rtl: true,
              textDirection: 'rtl',
          },
          title: {
              display: false,
          },

          customCanvasBackgroundColor: {
              color: 'white',
          },
      },
      interaction: {
          mode: 'nearest',
          intersect: true
      },
      onClick: (event, elements) => {
        if (elements.length) {
            const datasetIndex = elements[0].datasetIndex;
            const url = ptChart.data.datasets[datasetIndex].url;
            if (url) {
                window.open(url, '_blank');
            }
        }
    },
  },
});
function formatNumber(value) {
  return new Intl.NumberFormat('en-US').format(value);
}