const pCanvas = document.getElementById('p-canvas');
const cCanvas = document.getElementById('c-canvas');
let pChart, cChart;

cChart = new Chart(cCanvas, {
    type: 'bar',
    data: {
        labels: zapomatic_localized.c.data.labels,
        datasets: zapomatic_localized.c.data.datasets,
        },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        plugins: {
            legend: {
                display: false,
            },
            title: {
                display: true,
                text: 'מתחרים עם מוצרים משותפים'
            },
            customCanvasBackgroundColor: {
                color: 'white',
            },
        }
  },
});

pChart = new Chart(pCanvas, {
    type: 'line',
    data: {
        labels: zapomatic_localized.p.data.labels,
        datasets: zapomatic_localized.p.data.datasets
      },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        plugins: {
            tooltip: {
                mode: 'index',
                intersect: false,
                callbacks: {
                  title: function(context) {
                    return zapomatic_localized.p.data.tooltips_labels[context[0].dataIndex];
                  },
                },
            },
            legend: {
                display: true,
                position: 'right',
                onHover: (event, legendItem) => {
                    const datasetIndex = legendItem.datasetIndex;
                    pChart.data.datasets[datasetIndex].borderWidth = 6;
                    pChart.update();
                },
                onLeave: (event, legendItem) => {
                    const datasetIndex = legendItem.datasetIndex;
                    pChart.data.datasets[datasetIndex].borderWidth = 2;
                    pChart.update();
                },
            },
            title: {
                display: true,
                text: 'ממוצע מיקומים'
            },
            customCanvasBackgroundColor: {
                color: 'white',
            },
        },
        interaction: {
            mode: 'index',
            intersect: false
        },
        
  },
});