const button = document.getElementById('zapomatic-idata-submit');
const fileInput = document.getElementById('zapomatic-idata-file');
const title = document.getElementById('zapomatic-idata-title');
const titleDesc = document.getElementById('zapomatic-idata-title-desc');
const contentDiv = document.getElementById('zapomatic-idata-section');
const steps = document.querySelectorAll('.zapomatic-progress-steps li');
let progressBar = null;
let filePath;
let mapData = null;
let mappedData = null;
let mappedIds = null;
let productId = null;
let productIdIndex = null;
let selects;
button.addEventListener('click', ajaxCall);
function ajaxCall(e = null) {
  if (e) { e.preventDefault(); }
  const file = fileInput.files[0];
  if (!file) {
      alert('Please select a file.');
      return;
  }
  if ( button.name == 'map' ) { 
      if ( !isUniqueID() ) {
      alert('לא נבחר מזהה מוצר ייחודי למיפוי.');
      return;
    }
      if ( hasDuplicates( mapFields() ) ) {
        alert('נבחרו שדות כפולים למיפוי.');
        return;
      }
  }
  const formData = new FormData();
  formData.append('zapomatic-idata-file', file);
  formData.append('action', 'zapomatic_import_data');
  formData.append('step', button.name);
  formData.append('zapomatic-idata-map', JSON.stringify(mapData));
  formData.append('zapomatic-idata-mapped', JSON.stringify(mappedData));
  formData.append('zapomatic-idata-product-id', productId);
  formData.append('zapomatic-idata-product-index', productIdIndex);
  button.disabled = true;
  button.textContent = 'אנא המתן...';
  const xhr = new XMLHttpRequest();
  xhr.open('POST', ajaxurl, true);
  xhr.onload = function() {
    switch (button.name) {
      case 'upload':
        if (xhr.status === 200) {
          const response = JSON.parse(xhr.responseText);
          if (response.success) {
              filePath = response.data.file_path;
              contentDiv.innerHTML = '';
              contentDiv.classList.add("zapomatic-importer-mapping-table-wrapper");
              generateMapData(response.data.file_data);
              button.name = 'map';
              steps[0].classList.remove('active')
              steps[0].classList.add('done')
              steps[1].classList.add('active')
          }
          else {
              alert('Error: ' + response.data.message);
          }
        }
        else {
          alert('Failed to upload file. Status: ' + xhr.status);
        }
        break;
      case 'map':
        if (xhr.status === 200) {
          const response = JSON.parse(xhr.responseText);
          if (response.success) {
            mappedData = response.data.filtered_map;
            mappedIds = response.data.filtered_lines;
            button.name = 'update';
            contentDiv.innerHTML = '';
            contentDiv.classList.remove("zapomatic-importer-mapping-table-wrapper");
            steps[1].classList.remove('active');
            steps[1].classList.add('done');
            steps[2].classList.add('active');
            titleDesc.textContent = `מבצע עדכון של ${mappedIds.length} מוצרים...`;
            for (const prop in mappedIds) {
              var count = mappedIds[prop].index+1;
              var product_id = mappedIds[prop].product_id;
              if (product_id === null) {
                updatePb();
                addProgressNote(`שורה ${count} מתוך ${mappedIds.length} לא עודכנה: מזהה מוצר ריק.`);
                
              }
              else if (product_id === false) {
                updatePb();
                addProgressNote(`שורה ${count} מתוך ${mappedIds.length} לא עודכנה: מזהה מוצר לא נמצא.`);
          
              }
              else {
                productId = product_id;
                productIdIndex = mappedIds[prop].index;
                var updateAjax = ajaxCall();
              }
            }
          }
          else {
              alert('Error: ' + response.data.message);
          }
        }
        else {
          alert('Failed to receive data. Status: ' + xhr.status);
        }
        break;
        case 'update':
          if (xhr.status === 200) {
            const response = JSON.parse(xhr.responseText);
            if (response.success) {
              updatePb();
              for (let note of response.data.results) addProgressNote(note);
            }
            else {
              alert('Error: ' + response.data.message);
            }
          }
          else {
            alert('Failed to receive data. Status: ' + xhr.status);
          }
          break;
    }
    button.disabled = false;
    button.textContent = 'המשך';
  };
  xhr.onerror = function() {
      alert('An error occurred during the upload.');
      button.disabled = false;
      button.textContent = 'המשך';
  };
  xhr.send(formData);
}
function updatePb() {
  if (progressBar === null) {
    const pb = document.createElement("progress");
    pb.setAttribute('max', mappedIds.length);
    pb.setAttribute('value', '0');
    contentDiv.appendChild(pb);
    progressBar = pb;
  }
  progressBar.value = progressBar.value+1;
}
function addProgressNote(text) {
  const p = document.createElement("p");
  p.textContent = text;
  contentDiv.appendChild(p);
}
function hasDuplicates(obj) {
  const valuesArray = Object.values(obj);
  const uniqueValues = new Set(valuesArray);
  return uniqueValues.size !== valuesArray.length;
}
function isUniqueID() {
  const selectsArray = Array.from(selects);
  return selectsArray.some(select => select.value == '_unique_id');
}
function mapFields() {
  selects = contentDiv.querySelectorAll('table select');
  let arr = {};
  selects.forEach((select) => {
    if (select.value != '') {
      const i = select.getAttribute('rel');
      arr[i] = select.value;
    }
  });
  mapData = arr;
  return arr;
}

function generateMapData(data) {
  const table = document.createElement("table");
  table.classList.add("widefat")
  const theadRow = document.createElement("thead");
  table.appendChild(theadRow);
  const thColName = document.createElement("th");
  thColName.textContent = "שם עמודה";
  const thFieldMap = document.createElement("th");
  thFieldMap.textContent = "מיפוי לשדה";
  theadRow.appendChild(thColName);
  theadRow.appendChild(thFieldMap);
  const columns = Object.keys(data);
  var i = 0;
  for (let column of columns) {
    var tr = document.createElement("tr");
    table.appendChild(tr);
    var tdName = document.createElement("td");
    tdName.textContent = column;
    tr.appendChild(tdName);
    if (data[column] != "") {
      var tdDesc = document.createElement("span");
      tdDesc.classList.add('description')
      tdDesc.textContent = "דוגמה: "+data[column];
      tdName.appendChild(tdDesc);
    }
    var tdSelect = document.createElement("td");
    tr.appendChild(tdSelect);
    var select = document.createElement("select");
    select.setAttribute('rel', i);
    tdSelect.appendChild(select);
    var optionNone = document.createElement("option");
    optionNone.setAttribute('value', '');
    optionNone.textContent = 'לא לייבא';
    select.appendChild(optionNone);
    var optionUniqueId = document.createElement("option");
    optionUniqueId.setAttribute('value', '_unique_id');
    optionUniqueId.textContent = '* מזהה מוצר';
    select.appendChild(optionUniqueId);
    var optionNone2 = document.createElement("option");
    optionNone2.setAttribute('value', '');
    optionNone2.textContent = '--------------';
    select.appendChild(optionNone2);
    var optionModelUrl = document.createElement("option");
    optionModelUrl.setAttribute('value', '_zapbott_pd_zap_modelurl');
    optionModelUrl.textContent = 'קישור לעמוד המוצר בזאפ';
    select.appendChild(optionModelUrl);
    var optionRequiredPosition = document.createElement("option");
    optionRequiredPosition.setAttribute('value', '_zapbott_pd_zap_required_position');
    optionRequiredPosition.textContent = 'קבע מחיר לפי מקום';
    select.appendChild(optionRequiredPosition);
    var optionPriceDrop = document.createElement("option");
    optionPriceDrop.setAttribute('value', '_zapbott_pd_zap_price_drop');
    optionPriceDrop.textContent = 'בכמה? (₪)';
    select.appendChild(optionPriceDrop);
    var optionMinPrice = document.createElement("option");
    optionMinPrice.setAttribute('value', '_zapbott_pd_zap_min_price');
    optionMinPrice.textContent = 'מחיר מינימום (₪)';
    select.appendChild(optionMinPrice);
    var optionMaxPrice = document.createElement("option");
    optionMaxPrice.setAttribute('value', '_zapbott_pd_zap_max_price');
    optionMaxPrice.textContent = 'מחיר מקסימום (₪)';
    select.appendChild(optionMaxPrice);
    var optionDefaultPrice = document.createElement("option");
    optionDefaultPrice.setAttribute('value', '_zapbott_pd_zap_default_price');
    optionDefaultPrice.textContent = 'מחיר ברירת מחדל (₪)';
    select.appendChild(optionDefaultPrice);
    var optionZapName = document.createElement("option");
    optionZapName.setAttribute('value', '_zapmirror_product_name');
    optionZapName.textContent = 'שם מוצר לזאפ';
    select.appendChild(optionZapName);
    var optionZapDesc = document.createElement("option");
    optionZapDesc.setAttribute('value', '_zapmirror_product_description');
    optionZapDesc.textContent = 'תיאור מוצר לזאפ';
    select.appendChild(optionZapDesc);
    i++;
  }
  contentDiv.appendChild(table);
  selects = contentDiv.querySelectorAll('table select');
  return true;
}