
const leCanvas = document.getElementById('zapomatic-dashboard-le-chart');
const ptCanvas = document.getElementById('zapomatic-dashboard-pt-chart');
const cStatus = document.getElementById('zapomatic-status');
const nextExec = document.getElementById('zapomatic-next-exec');
const ae = document.getElementById('zapomatic-active-exec');
const aeTime = document.getElementById('zapomatic-active-exec-time');
const aeCounter = document.getElementById('zapomatic-active-exec-counter');
const aePb = document.getElementById('zapomatic-active-exec-pb');
const aePbFill = document.getElementById('zapomatic-active-exec-pb-fill');
const aePbValue = document.getElementById('zapomatic-active-exec-pb-value');
const aeTotal = document.getElementById('zapomatic-active-exec-total');
const aeCompleted = document.getElementById('zapomatic-active-exec-completed');
const aeErrors = document.getElementById('zapomatic-active-exec-errors');
const aeWarnings = document.getElementById('zapomatic-active-exec-warnings');
const aeStops = document.getElementById('zapomatic-active-exec-stops');
const aeErrorsValue = document.getElementById('zapomatic-active-exec-errors-value');
const aeWarningsValue = document.getElementById('zapomatic-active-exec-warnings-value');
const aeStopsValue = document.getElementById('zapomatic-active-exec-stops-value');
let leChart;
let ptChart;
jQuery( document ).ready( function($) {
    setInterval(function(){
    var data = {
        action: "zapomatic_dashboard_refresh"
    }
    $.post(ajaxurl, data, function(response) {
        let result = JSON.parse(response);
        cStatus.innerText = result.status;
        nextExec.innerText = result.next_exec;
        if ( result.active_exec ) {
          aeTime.innerText = result.active_exec.start_time;
          aeCompleted.innerText = result.active_exec.completed;
          aeTotal.innerText = result.active_exec.total;
          aeErrorsValue.innerText = result.active_exec.errors;
          aeWarningsValue.innerText = result.active_exec.warnings;
          aeStopsValue.innerText = result.active_exec.stops;
          p = Math.round((result.active_exec.completed / result.active_exec.total) * 100)+ '%';
          aePbFill.style.width = p;
          aePbValue.innerText = p;
          ae.style.display = "list-item";
          aeCounter.style.display = "list-item";
          aePb.style.display = "list-item";
          aeErrors.style.display = "list-item";
          aeWarnings.style.display = "list-item";
          aeStops.style.display = "list-item"; 
        }
        else {
          ae.style.display = "none";
          aeCounter.style.display = "none";
          aePb.style.display = "none";
          aeErrors.style.display = "none";
          aeWarnings.style.display = "none";
          aeStops.style.display = "none";
        }
    })
}, 2500);
});
function formatNumber(value) {
  return new Intl.NumberFormat('en-US').format(value);
}
if (zapomatic_localized.last_exec) {
  const lastExecLabels = [
    zapomatic_localized.last_exec.labels.total,
    zapomatic_localized.last_exec.labels.completed,
    zapomatic_localized.last_exec.labels.stops,
    zapomatic_localized.last_exec.labels.warnings,
    zapomatic_localized.last_exec.labels.errors, 
  ];
  const lastExecProducts = [
    zapomatic_localized.last_exec.total,
    zapomatic_localized.last_exec.completed,
    zapomatic_localized.last_exec.stops,
  ];
  const lastExecStatuses = [
    zapomatic_localized.last_exec.statuses_count.warnings,
    zapomatic_localized.last_exec.statuses_count.errors, 
  ];
  const lastExecStatusesLinks = [
    zapomatic_localized.last_exec.links.statuses+'=warnings',
    zapomatic_localized.last_exec.links.statuses+'=errors',
  ];
  
   leChart = new Chart(leCanvas, {
    type: 'pie',
    data: {
      labels: lastExecLabels,
      datasets: [
        {
          label: zapomatic_localized.last_exec.labels.products,
          data: lastExecProducts,
          backgroundColor: ['green', 'lightgreen', 'darkred'],
        },
        {
          label: zapomatic_localized.last_exec.labels.statuses,
          data: lastExecStatuses,
          backgroundColor: ['orange', 'red'],
        }
      ]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'right',
          labels: {
            generateLabels: function(chart) {
              const original = Chart.overrides.pie.plugins.legend.labels.generateLabels;
              const labelsOriginal = original.call(this, chart);
              let datasetColors = chart.data.datasets.map(function(e) {
                return e.backgroundColor;
              });
              datasetColors = datasetColors.flat();
              labelsOriginal.forEach((label, index) => {
                let totalDataPoints = 0;
                let datasetIndex = 0;
                for (let i = 0; i < chart.data.datasets.length; i++) {
                  totalDataPoints += chart.data.datasets[i].data.length;
                  if (index < totalDataPoints) {
                    datasetIndex = i;
                    break;
                  }
                }
                label.hidden = !chart.isDatasetVisible(datasetIndex);
                label.fillStyle = datasetColors[index];
              });
            
              return labelsOriginal;
            }
            
          },
          onClick: function(mouseEvent, legendItem, legend) {
            const chart = legend.chart;
            const index = legendItem.index;
            let totalDataPoints = 0;
            let datasetIndex = 0;
            for (let i = 0; i < chart.data.datasets.length; i++) {
              totalDataPoints += chart.data.datasets[i].data.length;
              if (index < totalDataPoints) {
                datasetIndex = i;
                break;
              }
            }
            const meta = chart.getDatasetMeta(datasetIndex);
            meta.hidden = !meta.hidden;
            chart.update();
          },
        },
        tooltip: {
          callbacks: {
            title: function(context) {
              return context[0].dataset.label;
            },
            label: function(context) {
              if (context.datasetIndex === 1) {
                var dataSetLabel = context.chart.data.labels[context.dataIndex+3];
              }
              else {
                var dataSetLabel = context.chart.data.labels[context.dataIndex];
              }
              return dataSetLabel + ': ' + context.formattedValue;
            }
          }
        },
        title: {
          display: false,
        }
      }
    },
  });
  leCanvas.onclick = function(e) {
    var slice = leChart.getElementsAtEventForMode(e, 'nearest', { intersect: true }, true);
    if (!slice.length) {
        slice = leChart.getElementsAtEventForMode(e, 'index', { intersect: false }, true);
    }
    if (!slice.length || slice[0].datasetIndex === 0) return;
    var datasetIndex = slice[0].datasetIndex;
    var dataIndex = slice[0].index;
    var link = lastExecStatusesLinks[dataIndex];
    if (link) {
        window.open(link, '_blank');
    }
  }
}
if (zapomatic_localized.price_trends) {

  ptChart = new Chart(ptCanvas, {
    type: 'line',
    data: {
      labels: zapomatic_localized.price_trends.dates,
      datasets: [
        {
          label: zapomatic_localized.price_trends.labels.values,
          data: zapomatic_localized.price_trends.values,
          borderWidth: 2,
          borderColor: 'rgb(62,156,53)',
          backgroundColor: 'rgba(62,156,53, 0.5)',
          pointStyle: 'circle',
          yAxisID: 'y',
          pointRadius: 3,
          pointHoverRadius: 5
        },
        {
          label: zapomatic_localized.price_trends.labels.ap,
          data: zapomatic_localized.average_positions,
          borderWidth: 2,
          yAxisID: 'y1',
          borderColor: 'rgb(0, 0, 0)',
          backgroundColor: 'rgba(0, 0, 0, 0.5)',
          pointStyle: 'circle',
          pointRadius: 3,
          pointHoverRadius: 5
        },
        {
          label: zapomatic_localized.price_trends.labels.totals,
          data: zapomatic_localized.price_trends.totals,
          borderWidth: 2,
          borderDash: [5, 5],
          yAxisID: 'y2',
          borderColor: 'rgb(0, 0, 255)',
          backgroundColor: 'rgba(0, 0, 255, 0.5)',
          pointStyle: 'circle',
          pointRadius: 3,
          pointHoverRadius: 5
        }
      ]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'bottom',
        },
        title: {
          display: false
        },
        tooltip: {
          mode: 'index',
          intersect: false,
          callbacks: {
            title: function(context) {
              return zapomatic_localized.price_trends.dates_values[context[0].dataIndex];
              
            },
            label: function(tooltipItem) {
              let label = tooltipItem.dataset.label || '';
              if (label) {
                label += ': ';
              }
              label += (tooltipItem.dataset.label !== zapomatic_localized.price_trends.labels.values) ? formatNumber(tooltipItem.raw) : '₪' + formatNumber(tooltipItem.raw); // Get the raw data value
              return label;
            }
          }
        }
      },
      interaction: {
        mode: 'index',
        intersect: false
      },
      scales: {
        x: {
        },
        y: {
          type: 'linear',
          display: false,
          stacked: false
        },
        y1: {
          type: 'linear',
          display: false,
          stacked: false
        },
        y2: {
          type: 'linear',
          display: false,
          stacked: false
        }
      }
    }
  });
}